% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nint.R
\name{nint_integrateNFunc}
\alias{nint_integrateNFunc}
\alias{nint_integrateNFunc_recursive}
\title{Integrate N Function}
\usage{
nint_integrateNFunc(f, funcs, x0, i0, ...)

nint_integrateNFunc_recursive(integrate1)
}
\arguments{
\item{integrate1}{\code{function(f, lowerLimit, upperLimit, ...)} which performs one dimensional integration.}

\item{f}{the scalar-valued wrapper function to be integrated.}

\item{funcs}{the list of function dimensions.}

\item{x0}{the partially realized point in the space.}

\item{i0}{the vector of indices of function dimensions in the space.}

\item{...}{other arguments passed to \code{f}.}
}
\value{
\code{nint_integrateNFunc} returns a single numeric.

\code{nint_integrateNFunc_recursive} returns a recursive implementation for \code{nint_integrateNFunc}.
}
\description{
Inferface to the integration over function dimensions.
}
\details{
\code{nint_integrate} uses \code{nint_integrateNFunc} to handle function dimensions.
See examples below on how to deploy different solutions.

The function built by \code{nint_integrateNFunc_recursive} directly sums over discrete dimensions and uses \code{integrate1} otherwise.
In conjunction with \code{integrateA} this is the default.
}
\examples{
dfltNFunc = nint_integrateNFunc

## area of circle
s = nint_space(
    nint_intvDim(-1, 1),
    nint_funcDim(function(x) nint_intvDim(c(-1, 1) * sin(acos(x[1])) ))
)
nint_integrate(function(x) 1, s) # pi
## see nint_integrate's examples for more sophisticated integrals


## prepare for custom recursive implementation
using = TRUE
nfunc = nint_integrateNFunc_recursive(
    function(f, lowerLimit, upperLimit, ...) {
        if (using) { # this function is called many times
            using <<- FALSE
            cat('using integrateA\\n')
        }
        integrateA(f, lowerLimit, upperLimit, ..., subdivisions=1)$value
    }
)
unlockBinding('nint_integrateNFunc', environment(nint_integrate))
assign('nint_integrateNFunc', nfunc, envir=environment(nint_integrate))

## integrate with custom recursive implementation
nint_integrate(function(x) 1, s) # pi


## prepare for custom solution
f = function(f, funcs, x0, i0, ...) {
    # add sophisticated code here
    print(list(f=f, funcs=funcs, x0=x0, i0=i0, ...))
    stop('do something')
}
unlockBinding('nint_integrateNFunc', environment(nint_integrate))
assign('nint_integrateNFunc', f, envir=environment(nint_integrate))

## integrate with custom solution
try(nint_integrate(function(x) 1, s))


assign('nint_integrateNFunc', dfltNFunc, envir=environment(nint_integrate))
}
\seealso{
\code{\link{nint_integrate}}

\code{\link{integrateA}}
}
