% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/by-sampleBy.R
\name{by-sample}
\alias{by-sample}
\alias{sample_by}
\alias{sampleBy}
\title{Sampling from a data frame}
\usage{
sample_by(data, formula, frac = 0.1, replace = FALSE, systematic = FALSE)

sampleBy(
  formula,
  frac = 0.1,
  replace = FALSE,
  data = parent.frame(),
  systematic = FALSE
)
}
\arguments{
\item{data}{A data frame.}

\item{formula}{A formula defining the grouping of the data frame.}

\item{frac}{The part of data to be sampled.}

\item{replace}{Is the sampling with replacement.}

\item{systematic}{Should sampling be systematic.}
}
\value{
A dataframe.
}
\description{
A data frame is split according to some variables in a
formula, and a sample of a certain fraction of each is drawn.
}
\details{
If systematic=FALSE (default) then frac gives the fraction
of data sampled. If systematic=TRUE and frac=.2 then every 1/.2
i.e. every 5th observation is taken out.
}
\examples{
data(dietox)
sampleBy(formula = ~ Evit + Cu, frac=.1, data = dietox)
}
\seealso{
\code{\link{orderBy}}, \code{\link{order_by}},
\code{\link{splitBy}}, \code{\link{split_by}},
\code{\link{summaryBy}}, \code{\link{summary_by}},
\code{\link{transformBy}}, \code{\link{transform_by}}
}
\keyword{utilities}
