\name{dGSEAwrite}
\alias{dGSEAwrite}
\title{Function to write out enrichment results}
\usage{
dGSEAwrite(eTerm, which_content = c("gadjp", "adjp", "pvalue", "FWER",
"FDR",
"qvalue", "nES", "ES"), which_score = c("gadjp", "adjp", "FWER", "FDR",
"qvalue", "nES"), cutoff = 0.1, filename = NULL, keep.significance = T)
}
\arguments{
\item{eTerm}{an object of class "eTerm"}

\item{which_content}{the content will be written out. It
includes two categories: i) based on "adjp" for adjusted
p value, "gadjp" for globally adjusted p value, "pvalue"
for p value, "FWER" for family-wise error rate, "FDR" for
false discovery rate, "qvalue" for q value; ii) based on
"ES" for enrichment score, "nES" for normalised
enrichment score. For the former, the content is : first
-1*log10-transformed, and then multiplied by -1 if nES is
negative.}

\item{which_score}{which statistics/score will be used
for declaring the significance. It can be "adjp" for
adjusted p value, "gadjp" for globally adjusted p value,
"FWER" for family-wise error rate, "FDR" for false
discovery rate, "qvalue" for q value}

\item{cutoff}{a cutoff to declare the signficance. It
should be used together with 'which_score'}

\item{filename}{a character string naming a filename}

\item{keep.significance}{logical to indicate whether or
not to mask those insignfiicant by NA. By default, it
sets to true to mask those insignfiicant by NA}
}
\value{
a data frame with following components: \itemize{
\item{\code{setID}: term ID} \item{\code{setSize}: the
number of genes in the set} \item{\code{name}: term name}
\item{\code{namespace}: term namespace}
\item{\code{distance}: term distance} \item{\code{sample
names}: sample names in the next columns} }
}
\description{
\code{dGSEAwrite} is supposed to write out enrichment
results.
}
\note{
If "filename" is not NULL, a tab-delimited text file will
be also written out.
}
\examples{
#output <- dGSEAwrite(eTerm, which_content="gadjp", which_score="gadjp", filename="eTerm.txt")
}
\seealso{
\code{\link{dGSEA}}
}

