% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schema.R
\name{db_schema_drop}
\alias{db_schema_drop}
\title{Remove a schema from a database}
\usage{
db_schema_drop(con, schema, force = FALSE, ...)
}
\arguments{
\item{con}{An object of class \code{"src"} or \code{"DBIConnection"}.}

\item{schema}{Class \code{character} or \code{SQL} (cf. Details), name of the schema}

\item{force}{Boolean, default \code{FALSE}. Set to \code{TRUE} to drop a schema and
all objects it contains at once. Currently only supported for Postgres/Redshift.}

\item{...}{Passed on to the individual methods.}
}
\value{
\code{NULL} invisibly.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{db_schema_drop()} deletes a schema from the database.
For certain DBMS it is possible to force the removal of a non-empty schema, see below.
}
\details{
Methods are not available for all DBMS.

An error is thrown if no schema of that name exists.

The argument \code{schema} (and \code{dbname} for MSSQL) can be provided as \code{SQL} objects.
Keep in mind, that in this case it is assumed that they are already correctly quoted as identifiers.

Additional arguments are:
\itemize{
\item \code{dbname}: supported for MSSQL. Remove a schema from a different
database on the connected MSSQL-server; default: database addressed by \code{con}.
}
}
\seealso{
Other schema handling functions: 
\code{\link{db_schema_create}()},
\code{\link{db_schema_exists}()},
\code{\link{db_schema_list}()}
}
\concept{schema handling functions}
