% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normality.R
\name{plot_normality}
\alias{plot_normality}
\alias{plot_normality.data.frame}
\title{Plot distribution information of numerical data}
\usage{
plot_normality(.data, ...)

\method{plot_normality}{data.frame}(
  .data,
  ...,
  left = c("log", "sqrt", "log+1", "log+a", "1/x", "x^2", "x^3", "Box-Cox",
    "Yeo-Johnson"),
  right = c("sqrt", "log", "log+1", "log+a", "1/x", "x^2", "x^3", "Box-Cox",
    "Yeo-Johnson"),
  col = "steelblue",
  typographic = TRUE
)
}
\arguments{
\item{.data}{a data.frame or a \code{\link{tbl_df}}.}

\item{...}{one or more unquoted expressions separated by commas.
You can treat variable names like they are positions.
Positive values select variables; negative values to drop variables.
If the first expression is negative, plot_normality() will automatically
start with all variables.
These arguments are automatically quoted and evaluated in a context where column names
represent column positions.
They support unquoting and splicing.

See vignette("EDA") for an introduction to these concepts.}

\item{left}{character. Specifies the data transformation method to draw the histogram in the 
lower left corner. The default is "log".}

\item{right}{character. Specifies the data transformation method to draw the histogram in the 
lower right corner. The default is "sqrt".}

\item{col}{a color to be used to fill the bars. The default is "steelblue".}

\item{typographic}{logical. Whether to apply focuses on typographic elements to ggplot2 visualization. 
The default is TRUE. if TRUE provides a base theme that focuses on typographic elements using hrbrthemes package.}
}
\description{
The plot_normality() visualize distribution information
for normality test of the numerical data.
}
\details{
The scope of the visualization is the provide a distribution information.
Since the plot is drawn for each variable, if you specify more than
one variable in the ... argument, the specified number of plots are drawn.

The argument values that left and right can have are as follows.:

\itemize{
  \item "log" : log transformation. log(x)
  \item "log+1" : log transformation. log(x + 1). Used for values that contain 0.
  \item "log+a" : log transformation. log(x + 1 - min(x)). Used for values that contain 0.   
  \item "sqrt" : square root transformation.
  \item "1/x" : 1 / x transformation
  \item "x^2" : x square transformation
  \item "x^3" : x^3 square transformation
  \item "Box-Cox" : Box-Box transformation
  \item "Yeo-Johnson" : Yeo-Johnson transformation
}
}
\section{Distribution information}{

The plot derived from the numerical data visualization is as follows.

\itemize{
  \item histogram by original data
  \item q-q plot by original data
  \item histogram by log transfer data
  \item histogram by square root transfer data
}
}

\examples{
\donttest{
# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

carseats <- carseats[, c("Income", "Price", "ShelveLoc", "Sales", "Urban", "US")]

# Visualization of all numerical variables
plot_normality(carseats)

# Select the variable to plot
plot_normality(carseats, Income, Price)
plot_normality(carseats, -Income, -Price, col = "gray")
plot_normality(carseats, 1)

# Change the method of transformation
plot_normality(carseats, Income, right = "1/x")

if (requireNamespace("forecast", quietly = TRUE)) {
  plot_normality(carseats, Income, left = "Box-Cox", right = "Yeo-Johnson")
} else {
  cat("If you want to use this feature, you need to install the rpart package.\n")
}
# Not allow typographic elements
plot_normality(carseats, Income, typographic = FALSE)

# Using dplyr::grouped_df
library(dplyr)

gdata <- group_by(carseats, ShelveLoc, US)
plot_normality(gdata)
plot_normality(gdata, "Sales")

# Using pipes ---------------------------------
# Visualization of all numerical variables
carseats \%>\%
 plot_normality()

# Positive values select variables
carseats \%>\%
plot_normality(Income, Price)

# Positions values select variables
# carseats \%>\%
#  plot_normality(1)

# Using pipes & dplyr -------------------------
# Plot 'Sales' variable by 'ShelveLoc' and 'US'
carseats \%>\%
 group_by(ShelveLoc, US) \%>\%
 plot_normality(Sales)

# extract only those with 'ShelveLoc' variable level is "Good",
# and plot 'Income' by 'US'
if (requireNamespace("forecast", quietly = TRUE)) {
  carseats \%>\%
   filter(ShelveLoc == "Good") \%>\%
   group_by(US) \%>\%
   plot_normality(Income, right = "Box-Cox")
} else {
  cat("If you want to use this feature, you need to install the rpart package.\n")
}
}
}
\seealso{
\code{\link{plot_normality.tbl_dbi}}, \code{\link{plot_outlier.data.frame}}.
}
