% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{summary.compare_numeric}
\alias{summary.compare_numeric}
\alias{print.compare_numeric}
\title{Summarizing compare_numeric information}
\usage{
\method{summary}{compare_numeric}(
  object,
  method = c("all", "correlation", "linear"),
  thres_corr = 0.3,
  thres_rs = 0.1,
  verbose = TRUE,
  ...
)

\method{print}{compare_numeric}(x, ...)
}
\arguments{
\item{object}{an object of class "compare_numeric", usually, a result of a call to compare_numeric().}

\item{method}{character. Select statistics to be aggregated. 
"correlation" calculates the Pearson's correlation coefficient, and "linear" returns the aggregation of the linear model.
"all" returns both information. 
However, the difference between summary.compare_numeric() and compare_numeric() is that only cases that are greater than the specified threshold are returned.
"correlation" returns only cases with a correlation coefficient greater than the thres_corr argument value. 
"linear" returns only cases with R^2 greater than the thres_rs argument.}

\item{thres_corr}{numeric. This is the correlation coefficient threshold of the correlation coefficient information to be returned. 
The default is 0.3.}

\item{thres_rs}{numeric. R^2 threshold of linear model summaries information to return. 
The default is 0.1.}

\item{verbose}{logical. Specifies whether to output additional information during the calculation process.
The default is to output information as TRUE. In this case, the function returns the value with invisible(). 
If FALSE, the value is returned by return().}

\item{...}{further arguments passed to or from other methods.}

\item{x}{an object of class "compare_numeric", usually, a result of a call to compare_numeric().}
}
\value{
An object of the class as compare based list.
The information to examine the relationship between numerical variables is as follows each components.
- correlation component : Pearson's correlation coefficient.
\itemize{
\item var1 : factor. The level of the first variable to compare. 'var1' is the name of the first variable to be compared.
\item var2 : factor. The level of the second variable to compare. 'var2' is the name of the second variable to be compared.
\item coef_corr : double. Pearson's correlation coefficient.
}

- linear component : linear model summaries
\itemize{
\item var1 : factor. The level of the first variable to compare. 'var1' is the name of the first variable to be compared.
\item var2 : factor. The level of the second variable to compare. 'var2' is the name of the second variable to be compared.
\item r.squared : double. The percent of variance explained by the model.
\item adj.r.squared : double. r.squared adjusted based on the degrees of freedom.
\item sigma : double. The square root of the estimated residual variance.
\item statistic : double. F-statistic.
\item p.value : double. p-value from the F test, describing whether the full regression is significant.
\item df : integer degrees of freedom.
\item logLik : double. the log-likelihood of data under the model.
\item AIC : double. the Akaike Information Criterion.
\item BIC : double. the Bayesian Information Criterion.
\item deviance : double. deviance.
\item df.residual : integer residual degrees of freedom.
}
}
\description{
print and summary method for "compare_numeric" class.
}
\details{
print.compare_numeric() displays only the information compared between the variables included in compare_numeric. 
When using summary.compare_numeric(), it is advantageous to set the verbose argument to TRUE if the user is only viewing information from the console. 
It is also advantageous to specify FALSE if you want to manipulate the results.
}
\examples{
# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

library(dplyr)

# Compare the all numerical variables
all_var <- compare_numeric(carseats)

# Print compare class object
all_var

# Compare the correlation that case of joint the Price variable
all_var \%>\% 
  "$"(correlation) \%>\% 
  filter(var1 == "Price" | var2 == "Price") \%>\% 
  arrange(desc(abs(coef_corr)))
  
# Compare the correlation that case of abs(coef_corr) > 0.3
all_var \%>\% 
  "$"(correlation) \%>\% 
  filter(abs(coef_corr) > 0.3)
  
# Compare the linear model that case of joint the Price variable  
all_var \%>\% 
  "$"(linear) \%>\% 
  filter(var1 == "Price" | var2 == "Price") \%>\% 
  arrange(desc(r.squared))
  
# Compare the two numerical variables
two_var <- compare_numeric(carseats, Price, CompPrice)

# Print compare class object
two_var
  
# Summary the all case : Return a invisible copy of an object.
stat <- summary(all_var)

# Just correlation
summary(all_var, method = "correlation")

# Just correlation condition by r > 0.2
summary(all_var, method = "correlation", thres_corr = 0.2)

# linear model summries condition by R^2 > 0.05
summary(all_var, thres_rs = 0.05)

# verbose is FALSE 
summary(all_var, verbose = FALSE)
  
}
\seealso{
\code{\link{plot.compare_numeric}}.
}
