% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing.R
\name{plot_na_intersect}
\alias{plot_na_intersect}
\title{Plot the combination variables that is include missing value}
\usage{
plot_na_intersect(
  x,
  only_na = TRUE,
  n_intersacts = NULL,
  n_vars = NULL,
  main = NULL,
  typographic = TRUE
)
}
\arguments{
\item{x}{data frames, or objects to be coerced to one.}

\item{only_na}{logical. The default value is FALSE. 
If TRUE, only variables containing missing values are selected for visualization. 
If FALSE, included complete case.}

\item{n_intersacts}{integer. Specifies the number of combinations of variables including missing values. 
The combination of variables containing many missing values is chosen first.}

\item{n_vars}{integer. Specifies the number of variables that contain missing values to be visualized. 
The default value is NULL, which visualizes variables containing all missing values. 
If this value is greater than the number of variables containing missing values, 
all variables containing missing values are visualized. Variables containing many missing values are chosen first.}

\item{main}{character. Main title.}

\item{typographic}{logical. Whether to apply focuses on typographic elements to ggplot2 visualization. 
The default is TRUE. if TRUE provides a base theme that focuses on typographic elements using hrbrthemes package.}
}
\description{
Visualize the combinations of missing value across cases.
}
\details{
The visualization consists of four parts.
The bottom left, which is the most basic, visualizes the case of cross(intersection)-combination. 
The x-axis is the variable including the missing value, and the y-axis represents the case of a combination of variables.
And on the marginal of the two axes, the frequency of the case is expressed as a bar graph. 
Finally, the visualization at the top right expresses the number of variables including missing values in the data set, 
and the number of observations including missing values and complete cases .
}
\examples{
# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

# Visualize the combination variables that is include missing value.
plot_na_intersect(carseats)
  
# Diagnose the data with missing_count using diagnose() function
library(dplyr)

if (!requireNamespace("mice", quietly = TRUE)) {
  stop("Package \"mice\" needed for this function to work. Please install it.",
  call. = FALSE)
}

mice::boys \%>\% 
  diagnose \%>\% 
  arrange(desc(missing_count))

# Visualize the combination variables that is include missing value
plot_na_intersect(mice::boys)

# Visualize variables containing missing values and complete case
plot_na_intersect(mice::boys, only_na = FALSE)

# Using n_vars argument
plot_na_intersect(mice::boys, n_vars = 5) 

# Using n_intersacts argument
plot_na_intersect(mice::boys, only_na = FALSE, n_intersacts = 7)

# Not allow typographic elements
plot_na_intersect(mice::boys, typographic = FALSE)

}
