% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binning.R
\name{binning}
\alias{binning}
\title{Binning the Numeric Data}
\usage{
binning(
  x,
  nbins,
  type = c("quantile", "equal", "pretty", "kmeans", "bclust"),
  ordered = TRUE,
  labels = NULL,
  approxy.lab = TRUE
)
}
\arguments{
\item{x}{numeric. numeric vector for binning.}

\item{nbins}{integer. number of intervals(bins). required. if missing, nclass.Sturges is used.}

\item{type}{character. binning method. Choose from "quantile", "equal", "equal", "pretty", "kmeans" and "bclust".
The "quantile" sets breaks with quantiles of the same interval.
The "equal" sets breaks at the same interval.
The "pretty" chooses a number of breaks not necessarily equal
to nbins using base::pretty function.
The "kmeans" uses stats::kmeans function to generate the breaks.
The "bclust" uses e1071::bclust function to generate the breaks using bagged clustering.
"kmeans" and "bclust" was implemented by classInt::classIntervals() function.}

\item{ordered}{logical. whether to build an ordered factor or not.}

\item{labels}{character. the label names to use for each of the bins.}

\item{approxy.lab}{logical. If TRUE, large number breaks are approximated to pretty numbers. 
If FALSE, the original breaks obtained by type are used.}
}
\value{
An object of bins class.
Attributes of bins class is as follows.
\itemize{
\item type : binning type, "quantile", "equal", "pretty", "kmeans", "bclust".
\item breaks : the number of intervals into which x is to be cut.
\item levels : levels of binned value.
\item raw : raw data, numeric vector corresponding to x argument.
}
}
\description{
The binning() converts a numeric variable to a categorization variable.
}
\details{
This function is useful when used with the mutate/transmute
function of the dplyr package.
}
\section{"bins" class attributes information}{

Attributes of the "bins" class that is as follows.

\itemize{
\item class : "bins"
\item levels : levels of factor or ordered factor 
\item type : binning method
\item breaks : breaks for binning
\item raw : raw data before binning
}

See vignette("transformation") for an introduction to these concepts.
}

\examples{
# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA
# Binning the carat variable. default type argument is "quantile"
bin <- binning(carseats$Income)
# Print bins class object
bin
# Summarise bins class object
summary(bin)
# Plot bins class object
plot(bin)
# Using labels argument
bin <- binning(carseats$Income, nbins = 4,
              labels = c("LQ1", "UQ1", "LQ3", "UQ3"))
bin
# Using another type argument
bin <- binning(carseats$Income, nbins = 5, type = "equal")
bin
bin <- binning(carseats$Income, nbins = 5, type = "pretty")
bin
bin <- binning(carseats$Income, nbins = 5, type = "kmeans")
bin
bin <- binning(carseats$Income, nbins = 5, type = "bclust")
bin

x <- sample(1:1000, size = 50) * 12345679
bin <- binning(x)
bin
bin <- binning(x, approxy.lab = FALSE)
bin

# extract binned results
extract(bin)

# -------------------------
# Using pipes & dplyr
# -------------------------
library(dplyr)

carseats \%>\%
 mutate(Income_bin = binning(carseats$Income) \%>\% 
                     extract()) \%>\%
 group_by(ShelveLoc, Income_bin) \%>\%
 summarise(freq = n()) \%>\%
 arrange(desc(freq)) \%>\%
 head(10)
 
}
\seealso{
\code{\link{binning_by}}, \code{\link{print.bins}}, \code{\link{summary.bins}}.
}
