% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binning.R
\name{summary.bins}
\alias{summary.bins}
\alias{print.bins}
\title{Summarizing Binned Variable}
\usage{
\method{summary}{bins}(object, ...)

\method{print}{bins}(x, ...)
}
\arguments{
\item{object}{an object of class "bins" and "optimal_bins",
usually, a result of a call to binning().}

\item{...}{further arguments passed to or from other methods.}

\item{x}{an object of class "bins" and "optimal_bins",
usually, a result of a call to binning().}
}
\value{
The function summary.bins() computes and returns a data.frame of summary statistics of the
binned given in object. Variables of data frame is as follows.
\itemize{
\item levels : levles of factor.
\item freq : frequency of levels.
\item rate : ratio of levels in total observations. it is not percentage.
}
}
\description{
summary method for class "bins" and "optimal_bins".
}
\details{
print.bins() tries to be smart about formatting the frequency of bins, binned type, number of bins.
summary.bins tries to be smart about formatting the levles, frequency of levels(bins),
the ratio of levels in total observations. And this information is data.frame object.

See vignette("transformation") for an introduction to these concepts.
}
\examples{
# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

# Binning the carat variable. default type argument is "quantile"
bin <- binning(carseats$Income)

# Print bins class object
bin

# Summarise bins class object
summary(bin)
}
\seealso{
\code{\link{binning}}
}
