% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sub_criteria.R
\name{sub_criteria}
\alias{sub_criteria}
\alias{attrs}
\title{Sub-criteria}
\usage{
sub_criteria(
  ...,
  match_funcs = diyar::exact_match,
  equal_funcs = diyar::exact_match,
  operator = "or"
)

attrs(..., .obj = NULL)
}
\arguments{
\item{...}{\code{[atomic]}. Attributes.}

\item{match_funcs}{\code{[function]}. User defined logical test for matches.}

\item{equal_funcs}{\code{[function]}. User defined logical test for identical record sets (all attributes of the same record).}

\item{operator}{\code{[character]}. Options are \code{"and"} or \code{"or"}.}

\item{.obj}{\code{[data.frame|list]}. Attributes}
}
\value{
\code{\link{sub_criteria}}
}
\description{
Additional matching criteria for each iteration of \bold{\code{\link{links}}} and \bold{\code{\link{episodes}}}.
}
\details{
\bold{\code{sub_criteria()}} - The mechanism for providing matching criteria to an iteration of \bold{\code{links}} or \bold{\code{episodes}}.
It creates a \code{sub_criteria} class object which contains the attributes to be compared,
logical tests for the comparisons (see \bold{\code{\link{predefined_tests}}} for examples) and
another set of logical tests to determine identical records.

\bold{\code{attrs()}} - Pass a collection of attributes to each \code{...} in \bold{\code{sub_criteria()}}.

Every attribute, including those in a collection, must have
the same length or a length of 1.
}
\examples{
# Sub-criteria
s_cri1 <- sub_criteria(c(30, 28, 40, 25, 25, 29, 27),
                       match_funcs = range_match)
s_cri2 <- sub_criteria(c(30, 28, 40, 25, 25, 29, 27),
                       match_funcs = exact_match)

# Nested sub-criteria
s_cri3 <- sub_criteria(s_cri1, s_cri2, operator = "or")
s_cri4 <- sub_criteria(s_cri1, s_cri3, operator = "and")

# Objects of the same length
attrs(month.abb, month.name)

# Or a data.frame or list with elements of the same length
attrs(.obj = mtcars)

# Or a combinaiton of the both
attrs(mtcars$mpg, mtcars$cyl, .obj = mtcars)

# Each can then be passed to a `sub-criteria`
sub_criteria(
month.abb,
month.name,
attrs(month.abb, month.name)
)

}
\seealso{
\code{\link{predefined_tests}}; \code{\link{links}}; \code{\link{episodes}}; \code{\link{eval_sub_criteria}}
}
