% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_s4.R
\name{to_s4}
\alias{to_s4}
\alias{to_df}
\title{Change the returned outputs of \code{diyar} functions from \code{data.frames} to S4 objects, and vice versa}
\usage{
to_s4(df)

to_df(s4)
}
\arguments{
\item{df}{\code{data.frame}. Returned output of \code{\link{record_group}}, \code{\link{episode_group}}, \code{\link{fixed_episodes}} and \code{\link{rolling_episodes}}}

\item{s4}{\link[=pid-class]{pid} or \link[=epid-class]{epid} objects}
}
\value{
to_s4 - \link[=pid-class]{pid} or \link[=epid-class]{epid} objects

to_df - \code{data.frame} object
}
\description{
Convert the returned output of \code{\link{record_group}}, \code{\link{episode_group}}, \code{\link{fixed_episodes}} and \code{\link{rolling_episodes}}
from the current default (\code{data.frame}) to \link[=pid-class]{pid} or \link[=epid-class]{epid} objects, and vice versa.
}
\examples{
data(infections)
dates <- infections$date
output <- fixed_episodes(dates, case_length=30)
output

# from a data.frame to pid/epid object
output_2 <- to_s4(output)
output_2

# from the a pid/epid object to a data.frame
output_3 <- to_df(output_2)
output_3

}
