% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fadLad.R
\name{fadlad}
\alias{fadlad}
\title{FAD - LAD matrix from occurrence data}
\usage{
fadlad(dat, tax, bin, ages = FALSE, na.rm = TRUE, zerodur = TRUE)
}
\arguments{
\item{dat}{\code{(data.frame)}: Occurrence data.}

\item{tax}{\code{(character)}: The column name of taxon names.}

\item{bin}{\code{(character)}: The column name of bin variable. If two column names are entered, then they will interpreted as the minimum and maximum age uncertainty. (see examples)}

\item{ages}{\code{(logical)}: Are the bin entries ages (reversed time axis)? Setting ages to TRUE will replace the entries in 'bin' column(s) with their additive inverses.}

\item{na.rm}{\code{(logical)}: Should taxa that have no valid FADs or LADs (due to only NA entries) be removed from the output?}

\item{zerodur}{\code{(logical)}: If set to \code{TRUE}, single-interval taxa will 0 durations. Setting this argument to FALSE will add 1 to the durations of all taxa, which can be useful for binned data.}
}
\description{
Function to generate range data from an occurrence dataset.
}
\details{
The function will output First and Last Appearance Data of the taxa in the dataset. Keep in mind that incomplete sampling will influence these data and will make the ranges appear shrunken.

The following variables are produced:

attribute \code{row.names}: The names of the taxa.

\code{FAD}: First appearance data, given in time slice numbers.

\code{LAD}: Last appearance data, given in time slice numbers.

\code{duration}: optionally, the duration of taxa in numeric ages. It is given for single-interval taxa as well assuming that the taxa's range span over the entire time slice.
}
\examples{
data(corals)

# binned data
  flBinned <- fadlad(corals, tax="genus", bin="stg")

# using basic bin lengths
  flDual <- fadlad(corals, tax="genus", bin=c("max_ma", "min_ma"), ages=TRUE)

# single age esimate 
  data(stages)
  corals$mid <- stages$mid[corals$stg]
  flSingle <- fadlad(corals, tax="genus", bin="mid", ages=TRUE)


}
