% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParameterSet.R
\name{[.ParameterSet}
\alias{[.ParameterSet}
\title{Extract one or more parameters from a ParameterSet}
\usage{
\method{[}{ParameterSet}(ps, ids, prefix = NULL, ...)
}
\arguments{
\item{ps}{\link{ParameterSet}\cr
\link{ParameterSet} from which to extract parameters.}

\item{ids}{\code{(character())} \cr
ids of parameters to extract, if \code{id} ends with \verb{__} then all parameters starting
with \code{ids__} are extracted and the prefix is ignored, \code{prefix} can be left \code{NULL}.
See examples.}

\item{prefix}{\code{(character(1))} \cr
An optional prefix to remove from ids after extraction, assumes \verb{__} follows the
prefix name, i.e. \code{prefix__ids}.}

\item{...}{\code{ANY} \cr
Ignored, added for consistency.}
}
\description{
Used to extract one or more parameters from a constructed \link{ParameterSet} or
\link{ParameterSetCollection}.
}
\examples{
ps <- VectorDistribution$new(
  distribution = "Binomial",
  params = data.table::data.table(prob = c(0.1, 0.6, 0.2), size = c(2, 4, 6))
)$parameters()

ps["Binom1__prob"] # extracts just Binom1__prob
ps["Binom1__prob", prefix = "Binom1"] # extracts Binom1__prob and removes prefix
ps["Binom1__"] # extracts all Binom1 parameters and removes prefix
}
