% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rep.Distribution.R
\name{rep.Distribution}
\alias{rep.Distribution}
\title{Replicate Distribution into Vector, Mixture, or Product}
\usage{
\method{rep}{Distribution}(x, times, class = c("vector", "product", "mixture"), ...)
}
\arguments{
\item{x}{\link{Distribution}}

\item{times}{\code{(integer(1))} Number of times to replicate the distribution}

\item{class}{\code{(character(1))} What type of vector to create, see description.}

\item{...}{Additional arguments, currently unused.}
}
\description{
Replicates a constructed distribution into either a
\itemize{
\item \link{VectorDistribution} (\code{class = "vector"})
\item \link{ProductDistribution} (\code{class = "product"})
\item \link{MixtureDistribution} (\code{class = "mixture"})
}

If the distribution is not a custom \link{Distribution} then uses the more efficient
\code{distribution/params} constructor, otherwise uses \code{distlist}.
}
\examples{
rep(Binomial$new(), 10)
rep(Gamma$new(), 2, class = "product")

}
