% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotter.R
\name{predict_PDP.1D.Plotter}
\alias{predict_PDP.1D.Plotter}
\title{Prediction Function for PDP Plots}
\usage{
predict_PDP.1D.Plotter(object, features = NULL, save = TRUE)
}
\arguments{
\item{object}{The Interpreter object to plot PDP curves for.}

\item{features}{A vector with the names of the features to predict ICE plots for}

\item{save}{A boolean indicator to indicate whether the calculations should be
saved in the interpreter object or not. This can help reduce
computation if the PDP functions are used many times, but requires
additional memory to store the predictions. By default, this is set
to TRUE.}
}
\value{
A list of data frames with the grid points and PDP prediction values
        for each feature in object
}
\description{
Gives prediction curve for all specified features in the
             plotter object
}
\details{
predict_PDP.1D.Plotter
}
\note{
This method is meant to primarily be used to find the exact values for the 1-D PDP
curves plotted. Note that after the PDP curve is plotted, the returned
object of this function will be the saved predictions for plotting the curve, rather
than a recalculation of the values.
}
