% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotter.R
\name{center.preds}
\alias{center.preds}
\title{Centers the predicted values for 1-d ICE and PDP plots or 2-d PDP plots}
\usage{
center.preds(object, features = NULL, plot.type, feats.2d = NULL)
}
\arguments{
\item{object}{The Interpreter object to use}

\item{features}{A vector of names for the 1-D features we want to center}

\item{plot.type}{The type of plot that the user wants to center the predictions of.
should be one of either "ICE", "PDP.1D", or "PDP.2D"}

\item{feats.2d}{A 2-column dataframe or matrix that gives the first variable in
in the first column, and the second variable in the next. The
number of rows is equal to the number of 2-D PDPs one would like
to center.}
}
\value{
A list of centered data frame/matrix of values for the plot
}
\description{
Given the specified 'center.at' values of the Interpreter object, this
             function centers all of the plots in the Interpreter object
             of the specified type of plot.
}
\details{
center.preds
}
\note{
This function is mainly used to examine the exact values in the plot if the
plot is centered. Note that this function should only be called after calling
one of the various predict functions that matches the 'plot.type' parameter
with 'save' equal to TRUE.
}
