% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncp.R
\name{NCP}
\alias{NCP}
\title{R6 object to use as non-cooperating party in a distributed homomorphic computation}
\description{
\code{NCP} objects are worker objects that separate a
master process from communicating directly with the worker
processes. Typically two such are needed for a distributed
homomorphic computation. A master process can communicate with
\code{NCP} objects and the \code{NCP} objects can communicate
with worker processes. However, the two \code{NCP} objects,
designated by numbers 1 and 2, are non-cooperating in the sense
that they don't communicate with each other and are isolated
from each other.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{pubkey}}{the master's public key visible to everyone}

\item{\code{pubkey_bits}}{the number of bits in the public key (used for reconstructing public key remotely by serializing to character)}

\item{\code{pubkey_n}}{the \code{n} for the public key used for reconstructing public key remotely}

\item{\code{den}}{the denominator for rational arithmetic}

\item{\code{den_bits}}{the number of bits in the denominator used for reconstructing denominator remotely}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{NCP$new()}}
\item \href{#method-getStateful}{\code{NCP$getStateful()}}
\item \href{#method-setParams}{\code{NCP$setParams()}}
\item \href{#method-getSites}{\code{NCP$getSites()}}
\item \href{#method-setSites}{\code{NCP$setSites()}}
\item \href{#method-addSite}{\code{NCP$addSite()}}
\item \href{#method-cleanupInstance}{\code{NCP$cleanupInstance()}}
\item \href{#method-run}{\code{NCP$run()}}
\item \href{#method-clone}{\code{NCP$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Create a new \code{NCP} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NCP$new(
  ncp_defn,
  comp_defn,
  sites = list(),
  pubkey_bits = NULL,
  pubkey_n = NULL,
  den_bits = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ncp_defn}}{the NCP definition; see example}

\item{\code{comp_defn}}{the computation definition}

\item{\code{sites}}{list of sites}

\item{\code{pubkey_bits}}{the number of bits in public key}

\item{\code{pubkey_n}}{the \code{n} for the public key}

\item{\code{den_bits}}{the number of bits in the denominator (power of 2) used in rational approximations}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a new \code{NCP} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getStateful"></a>}}
\subsection{Method \code{getStateful()}}{
Retrieve the value of the \code{stateful} field
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NCP$getStateful()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setParams"></a>}}
\subsection{Method \code{setParams()}}{
Set some parameters of the \code{NCP} object for homomorphic computations
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NCP$setParams(pubkey_bits, pubkey_n, den_bits)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pubkey_bits}}{the number of bits in public key}

\item{\code{pubkey_n}}{the \code{n} for the public key}

\item{\code{den_bits}}{the number of bits in the denominator (power of 2) used in rational approximations}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getSites"></a>}}
\subsection{Method \code{getSites()}}{
Retrieve the value of the private \code{sites} field
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NCP$getSites()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setSites"></a>}}
\subsection{Method \code{setSites()}}{
Set the value of the private \code{sites} field
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NCP$setSites(sites)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sites}}{the list of sites}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addSite"></a>}}
\subsection{Method \code{addSite()}}{
Add a url or worker object for a site for participating in the distributed computation. The worker object can be used to avoid complications in debugging remote calls during prototyping.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NCP$addSite(name, url = NULL, worker = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{of the site}

\item{\code{url}}{web url of the site; exactly one of \code{url} or \code{worker} should be specified}

\item{\code{worker}}{worker object for the site; exactly one of \code{url} or \code{worker} should be specified}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cleanupInstance"></a>}}
\subsection{Method \code{cleanupInstance()}}{
Clean up by destroying instance objects created in workspace.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NCP$cleanupInstance(token)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{token}}{the token for the instance}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-run"></a>}}
\subsection{Method \code{run()}}{
Run the distributed homomorphic computation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NCP$run(token)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{token}}{a unique token for the run, used to ensure that correct parts of cached results are returned appropriately}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the result of the computation
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NCP$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
