% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxstuff.R
\docType{class}
\name{CoxWorker}
\alias{CoxWorker}
\title{Create a worker object for use as a worker with master objects generated by \code{\link{CoxMaster}}}
\format{An \code{\link{R6Class}} generator object}
\usage{
CoxWorker
}
\description{
\code{CoxWorker} objects are worker objects at each site of
a distributed Cox model computation
}
\section{Methods}{


\describe{
  \item{\code{CoxWorker$new(defn, data, stateful=TRUE)}}{Create a new CoxWorker instance
        object using formuala and data. The stateful flag indicates whether the object
        state is to be saved between iterations}
  \item{\code{logLik(beta, ...)}}{Compute the partial log likelihood for the local data
        for the input parameter vector beta. The return value is a named list with
        three components: \code{value} contains the value of the log likelihood,
        \code{gradient} contains the score vector, and \code{hessian} contains
        the estimated hessian matrix}
  \item{\code{var(beta, ...)}}{Compute the variance of the parameter vector beta}
  \item{\code{kosher()}}{Check if inputs and state of object are sane. For future use}
  \item{\code{getP()}}{Returns the dimension of the parameter vector}
  \item{\code{getStateful()}}{Returns \code{TRUE} if object is stateful, else \code{FALSE}}
}
}

\seealso{
\code{CoxMaster} which goes hand-in-hand with this object
}
\keyword{datasets}
