% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/svdstuff.R
\docType{class}
\name{SVDWorker}
\alias{SVDWorker}
\title{Create a worker object for use as a worker with master objects generated by \code{\link{SVDMaster}}}
\format{An \code{\link{R6Class}} generator object}
\usage{
SVDWorker
}
\description{
\code{SVDWorker} objects are worker objects at each site of
a distributed SVD model computation
}
\section{Methods}{


\describe{
  \item{\code{SVDWorker$new(x, stateful=TRUE)}}{Create a new SVD worker object with data x and flag
        for preserving state between iterations}
  \item{\code{reset()}}{Initialize work matrix and set up starting values for iterating}
  \item{\code{dimX(...)}}{Return the dimensions of the matrix}
  \item{\code{updateV(arg, ...)}}{Return an updated value for the V vector, normalized by \code{arg}}
  \item{\code{updateU(arg, ...)}}{Return an updated value for the norm of the U vector}
  \item{\code{normU(arg, ...)}}{Normalize U vector by \code{arg}}
  \item{\code{fixU(arg, ...)}}{Construct the residual matrix using \code{arg}}
  \item{\code{getN(...)}}{Return the number of rows}
  \item{\code{getP(...)}}{Return the number of columns}
  \item{\code{kosher()}}{Check if inputs and state of object are sane. For future use}
  \item{\code{getStateful()}}{Returns \code{TRUE} if object is stateful, else \code{FALSE}}
}
}
\seealso{
\code{SVDMaster} which goes hand-in-hand with this object
}
\keyword{datasets}

