% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probes.R
\name{count_PhCh}
\alias{count_PhCh}
\alias{count_GC}
\alias{count_REP}
\alias{count_MFE}
\alias{count_TM}
\title{Calculate physical and chemical properties}
\usage{
count_PhCh(
  probe.var,
  trim = FALSE,
  data,
  digits = 4,
  mc.cores = 1,
  MFE.files.dir = NULL,
  delete.MFE.files = FALSE,
  GCmin = 40,
  GCmax = 60,
  nucl.pattern = c("a", "t", "g", "c"),
  n.crit = 5,
  RNAfold.path,
  temperature = 40,
  MFEmin = -3,
  TD.params = NULL,
  TMmin = 55,
  TMmax = 60,
  verbose = TRUE
)

count_GC(
  probe.var,
  trim.gc = FALSE,
  GCmin = 40,
  GCmax = 60,
  mc.cores = 1,
  add.to.data = FALSE,
  data,
  digits = 4
)

count_REP(
  probe.var,
  trim.rep = FALSE,
  nucl.pattern = c("a", "t", "g", "c"),
  n.crit = 5,
  mc.cores = 1,
  add.to.data = FALSE,
  data
)

count_MFE(
  probe.var,
  RNAfold.path,
  temperature = 40,
  trim.mfe = FALSE,
  MFEmin = -3,
  add.to.data = FALSE,
  data,
  MFE.files.dir = NULL,
  delete.MFE.files = FALSE,
  mc.cores = 1,
  digits = 4,
  verbose = TRUE
)

count_TM(
  probe.var,
  TD.params = NULL,
  trim.tm = FALSE,
  TMmin = 55,
  TMmax = 60,
  add.to.data = FALSE,
  data,
  digits = 4,
  mc.cores = 1,
  verbose = TRUE
)
}
\arguments{
\item{probe.var}{character; vector of nucleotide probes}

\item{trim, trim.gc, trim.rep, trim.mfe, trim.tm}{logical; whether to select results that meet the criterion}

\item{digits}{integer; number of decimal places to round the result}

\item{mc.cores}{integer; number of processors for parallel computation (not supported on Windows)}

\item{MFE.files.dir}{character; directory for RNAfold input and output files}

\item{delete.MFE.files}{logical; delete RNAfold input and output files}

\item{GCmin, GCmax}{numeric; minimum and maximum value of GC-content (percent, used if \code{trim = TRUE})}

\item{nucl.pattern}{character; vector of nucleotide pattern}

\item{n.crit}{integer; minimal amount of nucleotide pattern's repeats in a row to detect}

\item{RNAfold.path}{character; name and path to RNAfold executable file}

\item{temperature}{numeric; folding design temperature}

\item{MFEmin}{numeric; maximum value of folding energy (used if \code{trim = TRUE})}

\item{TD.params}{character; vector of length 4, contains designation for four tables with thermodynamic values
(nn_table - thermodynamic NN values, tmm_table - thermodynamic values for terminal mismatches,
imm_table -  thermodynamic values for internal mismatches, de_table - thermodynamic values for dangling ends).
See \link[TmCalculator]{Tm_NN} for details.}

\item{TMmin, TMmax}{numeric; minimum and maximum value of melting temperature (used if \code{trim = TRUE})}

\item{verbose}{logical; show messages}

\item{add.to.data, data}{logical; add result vector to specified data frame (used unconditionally if \code{trim = TRUE})}
}
\value{
If \code{trim = FALSE}, \code{count_PhCh} function returns data frame with GC-count (\code{GC.percent}),
nucleotide repeats (\code{repeats}, TRUE/FALSE), minimum folding energy (\code{MFE}) and melting temperature (\code{TM}) columns.
If \code{trim = TRUE}, \code{count_PhCh} function returns provided data frame with attached four columns
and rows selected according to values \code{GCmin, GCmax, n.crit, MFEmin, TMmin, TMmax}.

If \code{trim.gc= FALSE}, \code{count_GC} function returns \code{GC.percent} vector or data with attached \code{GC.percent} column (when \code{add.to.data = TRUE}).
If \code{trim.gc = TRUE}, \code{count_GC} function returns provided data frame with attached \code{GC.percent} column and rows selected according to \code{GCmin, GCmax} values.

If \code{trim.rep = FALSE}, \code{count_REP} function returns \code{repeats} vector (logical; TRUE/FALSE - there are/there are no nucleotide repeats) or data with attached \code{repeats} column (when \code{add.to.data = TRUE}).
If \code{trim.rep = TRUE}, \code{count_REP} function returns provided data frame with attached \code{repeats} column and rows selected according to \code{n.crit} value.

If \code{trim.mfe = FALSE}, \code{count_MFE} function returns \code{MFE} vector or data with attached \code{MFE} column (when \code{add.to.data = TRUE}).
If \code{trim.mfe = TRUE}, \code{count_MFE} function returns provided data frame with attached \code{MFE} column and rows selected according to \code{MFEmin} value.

If \code{trim.tm = FALSE}, \code{count_TM} function returns \code{TM} vector or data with attached \code{TM} column (when \code{add.to.data = TRUE}).
If \code{trim.tm = TRUE}, \code{count_TM} function returns provided data frame with attached \code{TM} column and rows selected according to \code{TMmin, TMmax} values.
}
\description{
Calculates GC-content, detects several nucleotides in a row, calculates minimum folding energy and melting temperature for oligonucleotide probes.
}
\details{
GC-content trimming selects results that are between \code{GCmin} and \code{GCmax} (inclusive).
Nucleotides' amount trimming deletes probes that contain \code{n.crit} or more of same nucleotides (pattern) in a row.
Minimum folding energy trimming selects results that are equal or more than \code{MFEmin}.
Melting temperature trimming selects results that are between \code{TMmin} and \code{TMmax} (inclusive).

This function is using ViennaRNA service to count minimum folding energy. ViennaRNA Package (UNIX or Windows) must be installed.
While counting MFE, working directory is set to \code{MFE.files.dir} and input and output files
for ViennaRNA ("seq_in" and "seq_out") are created in the working directory.Afterwards the working directory is changed back to user's setting.
If no \code{MFE.files.dir} exists it is created and is not deleted even if \code{delete.MFE.files = TRUE}.

Melting temperature is counted with \link[TmCalculator]{Tm_NN} function. Indication of thermodynamic values must be provided.
By default they are: nn_table = "DNA_NN4", tmm_table = "DNA_TMM1", imm_table = "DNA_IMM1", de_table = "DNA_DE1".
}
\section{Functions}{
\itemize{
\item \code{count_PhCh}: Calculates GC.percent, detects several nucleotides in a row, calculates minimum folding energy and melting temperature

\item \code{count_GC}: Calculates GC-content (percent)

\item \code{count_REP}: Detects several nucleotides in a row

\item \code{count_MFE}: Calculates minimum folding energy

\item \code{count_TM}: Calculates melting temperature
}}

\examples{
probes <- data.frame (ids = 1:3,  probes = c ("acacacacacaca", "aaaaagggggtttttccccc",
                                             "atgcgctagctcagc"))
probes <- count_GC (probe.var = probes$probes, trim.gc = FALSE, GCmin = 40, GCmax = 60,
                   add.to.data = TRUE, data = probes)

probes <- count_REP (probe.var = probes$probes, trim.rep = FALSE, n.crit = 5,
                    add.to.data = TRUE, data = probes)
\dontrun{
# This function is using ViennaRNA service. ViennaRNA Package must be installed.
MFE.files.dir <- tempdir()
probes <- count_MFE (probe.var = probes$probes, RNAfold.path = "D:/Vienna/RNAfold.exe",
                    temperature = 40, trim.mfe = FALSE, MFEmin = 0,
                    MFE.files.dir = MFE.files.dir, delete.MFE.files = TRUE,
                    add.to.data = TRUE, data = probes, mc.cores = 1)
unlink (MFE.files.dir, recursive = TRUE)
}
probes <- count_TM (probe.var = probes$probes, TD.params = NULL, trim.tm = FALSE,
                   TMmin = 55, TMmax = 60, add.to.data = TRUE, data = probes,
                   digits = 4, mc.cores = 1)
# All in one command
\dontrun{
# This function is using ViennaRNA service. ViennaRNA Package must be installed.
MFE.files.dir <- tempdir()
probes2 <- count_PhCh (probe.var = probes$probes, trim = FALSE,
                      nucl.pattern = c ("a", "t", "g", "c"), n.crit = 5,
                      MFE.files.dir = MFE.files.dir, delete.MFE.files = TRUE,
                      RNAfold.path = "D:/Vienna/RNAfold.exe", temperature = 40,
                      TD.params = NULL, digits = 3, mc.cores = 1,
                      data = probes)
unlink (MFE.files.dir, recursive = TRUE)
}

}
\references{
Lorenz R., Stephan H.B., Höner zu Siederdissen C. et al. (2011). ViennaRNA Package 2.0. Algorithms for Molecular Biology, 6, 1.
\url{https://almob.biomedcentral.com/articles/10.1186/1748-7188-6-26}.
}
\author{
Elena N. Filatova
}
