% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paper.R
\name{paper_compute}
\alias{paper_compute}
\alias{paper_count}
\alias{paper_total}
\alias{paper_value}
\alias{paper_duration}
\title{Papers' estimation}
\usage{
paper_count(
  portfolio_quantity,
  portfolio_price,
  market_price,
  allow_short = TRUE
)

paper_total(
  portfolio_quantity,
  portfolio_price,
  market_price,
  allow_short = TRUE
)

paper_value(
  portfolio_quantity,
  portfolio_price,
  market_price,
  allow_short = TRUE
)

paper_duration(
  portfolio_quantity,
  portfolio_price,
  market_price,
  datetime_difference = NULL,
  previous_datetime = NULL,
  transaction_datetime = NULL,
  allow_short = TRUE
)

paper_compute(
  portfolio_quantity,
  portfolio_price,
  market_price,
  previous_datetime,
  transaction_datetime,
  assets,
  allow_short = TRUE,
  method = "all"
)
}
\arguments{
\item{portfolio_quantity}{Numeric vector. The portfolio quantities of assets into the
investor's portfolio.}

\item{portfolio_price}{Numeric vector. The portfolio prices of assets into the
investor's portfolio.}

\item{market_price}{Numeric vector. The market prices of assets into the
investor's portfolio.}

\item{allow_short}{Logical. If TRUE short positions are allowed, otherwise only
long positions are allowed.}

\item{datetime_difference}{Numeric value of time difference between the previous_datetime
and the transaction_datetime, computed through \code{\link{difftime_financial}}.
If NULL, then previous_datetime and transaction_datetime must be specified.}

\item{previous_datetime}{POSIXct value. The date-time of the last transaction
performed by the investor.}

\item{transaction_datetime}{POSIXct value. The date-time at which the transaction
is going to occur.}

\item{assets}{Character vector. The name of assets into the investor's
portfolio but the traded asset.}

\item{method}{Character string. The method used to compute papers.
Allowed values are "count", "total", "value", "duration" and "all".}
}
\value{
The described functions have different return behaviors
\itemize{
\item \code{paper_compute} returns a data frame containing the values of
paper gains and paper losses computed by means of the chosen method
on each portfolio assets.
\item \code{paper_count} returns a named vector containing the values of
paper gains and paper losses computed using the count method.
\item \code{paper_total} returns a named vector containing the values of
paper gains and paper losses computed using the total method.
\item \code{paper_value} returns a named vector containing the values of
paper gains and paper losses computed using the value method.
\item \code{paper_duration} returns a named vector containing the values
of paper gains and paper losses computed using the duration method.
}

In particular:
\itemize{
\item \code{RG_"method"} contains Realized Gains results
\item \code{RL_"method"} contains Realized Losses results
\item \code{PG_"method"} contains Paper Gains results
\item \code{PL_"method"} contains Paper Losses results
}
}
\description{
Compute paper gains and paper losses as either simple counts,
total quantities, expected returns and financial duration.
}
\section{Functions}{
\itemize{
\item \code{paper_count}: Computation of paper gains and paper losses as
simple counts (default method).

\item \code{paper_total}: Computation of paper gains and paper losses as
total quantity of assets.

\item \code{paper_value}: Computation of paper gains and paper losses as
expected return of assets.

\item \code{paper_duration}: Computation of paper gains and paper losses as
financial duration.

\item \code{paper_compute}: Wrapper that calls other paper_. functions to
compute paper gains and paper losses based on the chosen method.
}}

\seealso{
\code{\link{realized_compute}}, \code{\link{gains_losses}}
}
