% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispRity.utilities.R
\name{scale.dispRity}
\alias{scale.dispRity}
\alias{rescale.dispRity}
\title{Rescaling and centering disparity results.}
\usage{
\method{scale}{dispRity}(x, center = FALSE, scale = TRUE, ...)
}
\arguments{
\item{x}{a \code{dispRity} object.}

\item{center}{either a \code{logical} value or a \code{numeric} vector of length equal to the number of elements of \code{data} (default is \code{FALSE}).}

\item{scale}{either a \code{logical} value or a \code{numeric} vector of length equal to the number of elements of \code{data} (default is \code{TRUE}).}

\item{...}{optional arguments to be passed to \code{scale}.}
}
\description{
Scales or/and centers the disparity measurements.
}
\details{
To scale or and center using the full distribution (i.e. all the disparity values) or only the distribution within each subsets of bootstraps you can use the optional argument \code{use.all} as a logical. By default is \code{use.all = TRUE} and uses all the disparity values not only the ones in the subset.
}
\examples{
## Load the disparity data based on Beck & Lee 2014
data(disparity)

## Scaling the data
summary(scale.dispRity(disparity, scale = TRUE)) # Dividing by the maximum
## Multiplying by 10 (dividing by 0.1)
summary(scale.dispRity(disparity, scale = 0.1))

}
\seealso{
\code{\link{dispRity}}, \code{\link{test.dispRity}}, \code{\link[base]{scale}}.
}
\author{
Thomas Guillerme
}
