% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disequilibrium_model.R
\name{has_shortage}
\alias{has_shortage}
\alias{has_shortage,disequilibrium_model-method}
\title{Checks if an observation is in a shortage stage.}
\usage{
has_shortage(object, parameters)

\S4method{has_shortage}{disequilibrium_model}(object, parameters)
}
\arguments{
\item{object}{A disequilibrium model object.}

\item{parameters}{A vector of parameters at which the shortage probabilities are evaluated.}
}
\value{
A vector of Boolean values indicating observations with shortages.
}
\description{
Returns TRUE for the indices at which the shortages of the market are non-negative, i.e. the
market is in an excess demand state. Returns FALSE for the remaining indices. The evaluation
of the shortages is performed using the passed parameter vector.
}
\examples{
\donttest{
simulated_data <- simulate_model_data(
  "diseq_basic", 500, 3, # model type, observed entities, observed time points
  -0.9, 8.9, c(0.3, -0.2), c(-0.03, -0.01), # demand coefficients
  0.9, 4.2, c(0.03), c(-0.05, 0.02) # supply coefficients
)

# initialize the model
model <- new(
  "diseq_basic", # model type
  c("id", "date"), "Q", "P", # keys, quantity, and price variables
  "P + Xd1 + Xd2 + X1 + X2", "P + Xs1 + X1 + X2", # equation specifications
  simulated_data, # data
  use_correlated_shocks = TRUE # allow shocks to be correlated
)

# estimate a model object
est <- estimate(model)

# get the indices of  estimated shortages
has_short <- has_shortage(model, est@coef)
}
}
