% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disco.R
\name{modCor}
\alias{modCor}
\title{Calculate correlation between regulation of orthologous genes in a chosen gene set}
\usage{
modCor(x, g = NULL, method = "pearson")
}
\arguments{
\item{x}{an object of class matchedOrtholog}

\item{g}{either a vector of gene names of genes of interest, 
or an object of class "tmod" with definitions of modules. If
NULL, all genes will be used}

\item{method}{method for calculation of correlation (default: pearson)}
}
\value{
data frame with two columns: Cor - calculated correlation between the genes, 
        P.Value - p value from test of significance of the correlation,
        NGenes - number of genes included in correlation calculation. 
        Row names of the data frame correspond to the names of the modules.
}
\description{
Calculates correlation between regulation of group of genes in two data sets. 
Takes as arguments an object of class matchedOrtholog, a vector of genes of interest
(for example, genes belonging to an expression module) and method of correlation calculation. The
function also checks how many of the genes in the vector are present in the matchedOrtholog object.
frame.
}
\examples{
library(tmod)
data(tmod)
data(orthologs)

genes <- tmod$MODULES2GENES[["LI.M0"]]
a <- modCor(orthologs, genes)

# Using tmod objects directly
a <- modCor(orthologs, tmod[c("LI.M0", "LI.M1.0")], "spearman")
}
