% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_clusters.R
\name{PosteriorClusters}
\alias{PosteriorClusters}
\title{Generate the posterior clusters of a Dirichlet Process}
\usage{
PosteriorClusters(dpobj, ind)
}
\arguments{
\item{dpobj}{Fitted Dirichlet process}

\item{ind}{Index for which the posterior will be drawn from. Defaults to the last iteration of the fit.}
}
\value{
A list with the weights and cluster parameters that form the posterior of the Dirichlet process.
}
\description{
Using the stick breaking representation the user can draw the posterior clusters and weights for a fitted Dirichlet Process.
See also \code{\link{PosteriorFunction}}.
}
\examples{
y <- rnorm(10)
dp <- DirichletProcessGaussian(y)
dp <- Fit(dp, 5)
postClusters <- PosteriorClusters(dp)

}
