% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{sumsquared}
\alias{sumsquared}
\title{Fast Calculation of Sum-squared for Large Matrices/Vectors}
\arguments{
\item{x}{double, integer, or logical vector/matrix}
}
\value{
A numerical scalar
}
\description{
Calculate \code{sum(x^2)}, but faster when the number of
elements exceeds 1000.
}
\examples{

x <- rnorm(10000)
sumsquared(x)

# Compare speed
microbenchmark::microbenchmark(
  cpp = {sumsquared(x)},
  r = {sum(x^2)}
)

}
