% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallels-rscripts.R
\name{async_works}
\alias{async_works}
\title{Run jobs in other R sessions without waiting}
\usage{
async_works(
  X,
  FUN,
  ...,
  .globals = NULL,
  .name = "Untitled",
  .rs = FALSE,
  .wait = TRUE,
  .chunk_size = Inf,
  .nworkers = future::availableCores(),
  .simplify = FALSE,
  .quiet = FALSE,
  .log
)
}
\arguments{
\item{X}{vector or list to be applied}

\item{FUN}{function with the first argument to be each element of \code{X}}

\item{...}{further arguments to be passed to \code{FUN}}

\item{.globals}{global variables to be evaluated in \code{FUN}}

\item{.name}{job names, used if backed by \code{rstudioapi} jobs}

\item{.rs}{whether to use \code{rstudioapi} jobs}

\item{.wait}{whether to wait for the results}

\item{.chunk_size}{used only when \code{.wait=FALSE}, chunk size for each
workers at a time. Only useful for printing progress messages, but might
slow down the process when \code{.chunk_size} is too small}

\item{.nworkers}{number of workers at a time}

\item{.simplify}{whether to simplify the results, i.e. merge list of results
to vectors or arrays}

\item{.quiet}{whether to suppress the printing messages}

\item{.log}{internally used}
}
\value{
If \code{.wait=TRUE}, returns the applied results of \code{FUN} on
each of \code{X}. The result types depend on \code{.simplify} (compare
the difference between \code{\link{lapply}} and \code{\link{sapply}}). If
\code{.wait=FALSE}, then returns a function that can check the result. The
function takes \code{timeout} argument that blocks the session at
most \code{timeout} seconds waiting for the results. See examples.
}
\description{
Run jobs in other R sessions without waiting
}
\details{
Unlike \code{future} package, where the global variables can be
automatically detected, \code{async_works} require users to specify global
variables explicitly via \code{.globals}

\code{async_works} is almost surely slower than \code{future.apply} packages.
However, it provides a functionality that \code{future.apply} can hardly
achieve: being non-block. When setting \code{.wait=FALSE}, the process will
run in the background, and one may run as many of these tasks as they want.
This is especially useful when large data generating process occurs (
such as read in from a file, process, generate summarizing reports).
}
\examples{
\dontrun{
# requires a sub-process to run the code

# Basic usage
a <- 1
async_works(1:10, function(ii){
  ii + a # sub-process don't know a, hence must pass a as globals
}, .globals = list(a = a))

# non-blocking case
system.time({
  check <- async_works(1:10, function(ii){
    # simulating process, run run run
    Sys.sleep(ii)
    Sys.getpid()
  }, .wait = FALSE)
})

# check the results
res <- check(timeout = 0.1)
attr(res, 'resolved') # whether it's resolved

# block the session waiting for the results
res <- check(timeout = Inf)
attr(res, 'resolved')


}

}
