% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viz_labels.R
\name{viz_labels}
\alias{viz_labels}
\title{Non-Overlapping Text Labels}
\usage{
viz_labels(
  x,
  y,
  z,
  labels,
  ...,
  margin = 1,
  axes = c(1, 2),
  top = 10,
  box = FALSE,
  segment = FALSE,
  cex = graphics::par("cex"),
  col = graphics::par("fg"),
  bg = graphics::par("bg"),
  font = graphics::par("font")
)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector giving the x and y coordinates of a set of
points. If \code{y} is missing, \code{x} must be a \code{\linkS4class{CA}}, \code{\linkS4class{MCA}} or
\code{\linkS4class{PCA}} object.}

\item{z}{A \code{\link{numeric}} vector giving an extra variable for subsetting.}

\item{labels}{A \code{\link{character}} vector specifying the text to be written.}

\item{margin}{A length-one \code{\link{numeric}} vector giving the subscript
which the data will be returned: \code{1} indicates individuals/rows (the
default), \code{2} indicates variables/columns.}

\item{axes}{A length-two \code{\link{numeric}} vector giving the dimensions to be
plotted.}

\item{top}{An \code{\link{integer}} specifying the number of labels to draw.
Only the labels of the \code{top} \eqn{n} observations along \code{z} will be drawn.
If \code{NULL}, all labels are drawn.}

\item{box}{A \code{\link{logical}} scalar: should a box be drawn underneath labels?}

\item{segment}{A \code{\link{logical}} scalar: should segments be drawn?}
}
\description{
Non-Overlapping Text Labels
}
\keyword{internal}
