% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/viz_ellipse.R,
%   R/wrap_ellipses.R
\docType{methods}
\name{viz_confidence}
\alias{viz_confidence}
\alias{viz_confidence-method}
\alias{wrap_confidence}
\alias{wrap_confidence-method}
\alias{viz_confidence,MultivariateAnalysis-method}
\alias{viz_confidence,BootstrapCA-method}
\alias{viz_confidence,PCOA-method}
\alias{wrap_confidence,MultivariateAnalysis-method}
\alias{wrap_confidence,PCOA-method}
\title{Confidence Ellipses}
\usage{
viz_confidence(x, ...)

wrap_confidence(x, ...)

\S4method{viz_confidence}{MultivariateAnalysis}(
  x,
  ...,
  margin = 1,
  axes = c(1, 2),
  group = NULL,
  level = 0.95,
  color = NULL,
  fill = FALSE,
  symbol = FALSE
)

\S4method{viz_confidence}{BootstrapCA}(
  x,
  ...,
  margin = 1,
  axes = c(1, 2),
  level = 0.95,
  color = FALSE,
  fill = FALSE,
  symbol = FALSE
)

\S4method{viz_confidence}{PCOA}(
  x,
  ...,
  axes = c(1, 2),
  group = NULL,
  level = 0.95,
  color = NULL,
  fill = FALSE,
  symbol = FALSE
)

\S4method{wrap_confidence}{MultivariateAnalysis}(x, margin = 1, axes = c(1, 2), group = NULL, level = 0.95)

\S4method{wrap_confidence}{PCOA}(x, axes = c(1, 2), group = NULL, level = 0.95)
}
\arguments{
\item{x}{An object from which to wrap observations (a \code{\linkS4class{CA}},
\code{\linkS4class{MCA}} or \code{\linkS4class{PCA}} object).}

\item{...}{Further \link[graphics:par]{graphical parameters} to be passed to
\code{\link[graphics:polygon]{graphics::polygon()}}.}

\item{margin}{A length-one \code{\link{numeric}} vector giving the subscript which the
data will be returned: \code{1} indicates individuals/rows (the default), \code{2}
indicates variables/columns.}

\item{axes}{A length-two \code{\link{numeric}} vector giving the dimensions
for which to compute results.}

\item{group}{A vector specifying the group an observation belongs to.}

\item{level}{A \code{\link{numeric}} vector specifying the confidence/tolerance level.}

\item{color}{The colors for borders (will be mapped to \code{group}).
Ignored if set to \code{FALSE}. If \code{NULL}, the default color scheme will be used.}

\item{fill}{The background colors (will be mapped to \code{group}).
Ignored if set to \code{FALSE}.}

\item{symbol}{A vector of symbols (will be mapped to \code{group}).
Ignored if set to \code{FALSE}.}
}
\value{
\code{wrap_confidence()} returns a \code{\link{data.frame}} of envelope \code{x} and \code{y}
coordinates. An extra column named \code{group} is added specifying the group an
observation belongs to.

\code{viz_confidence()}is called for its side-effects: it results in a graphic
being displayed. Invisibly returns \code{x}.
}
\description{
Plots confidence ellipses.
}
\examples{
## Load data
data("iris")

## Compute principal components analysis
X <- pca(iris, scale = TRUE, sup_quali = "Species")

## Compute confidence ellipse coordinates
conf <- wrap_confidence(X, margin = 1, group = "Species", level = 0.95)

## Plot confidence ellipses
col <- c("#004488", "#DDAA33", "#BB5566")
viz_rows(X, extra_quali = iris$Species, color = col)
viz_confidence(X, group = iris$Species, color = col, level = 0.95)
}
\seealso{
Other envelopes: 
\code{\link{viz_ellipses}()},
\code{\link{viz_hull}()},
\code{\link{viz_tolerance}()}
}
\author{
N. Frerebeau
}
\concept{envelopes}
