% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{showProbPlot}
\alias{showProbPlot}
\title{Show distribution plots of the cell proportions generated by
\code{\link{generateBulkCellMatrix}}}
\usage{
showProbPlot(object, type.data, set, type.plot = "boxplot")
}
\arguments{
\item{object}{\code{\linkS4class{DigitalDLSorter}} object with
\code{prob.cell.types} slot with \code{plot} slot.}

\item{type.data}{Subset of data to show: \code{train} or \code{test}.}

\item{set}{Integer determining which of the 6 different subsets to display.}

\item{type.plot}{Character determining which type of visualization to
display. It can be \code{'boxplot'}, \code{'violinplot'}, \code{'linesplot'} or
\code{'ncelltypes'}. See Description for more information.}
}
\value{
A ggplot object.
}
\description{
Show distribution plots of the cell proportions generated by
\code{\link{generateBulkCellMatrix}}. These frequencies will determine the
proportion of different cell types used during the simulation of pseudo-bulk
RNA-Seq samples. There are 6 subsets of proportions generated by different
approaches that can be visualized in three ways: box plots, violin plots and
lines plots. You can also plot the probabilities based on the number of
different cell types present in the samples by setting \code{type.plot =
'nCellTypes'}.
}
\details{
These plots are only for diagnostic purposes. This is the reason because they
are generated without any parameter introduced by the user.
}
\examples{
# simulating data
set.seed(123) # reproducibility
sce <- SingleCellExperiment::SingleCellExperiment(
  assays = list(
    counts = matrix(
      rpois(100, lambda = 5), nrow = 40, ncol = 30, 
      dimnames = list(paste0("Gene", seq(40)), paste0("RHC", seq(30)))
    )
  ),
  colData = data.frame(
    Cell_ID = paste0("RHC", seq(30)),
    Cell_Type = sample(x = paste0("CellType", seq(4)), size = 30, 
                       replace = TRUE)
  ),
  rowData = data.frame(
    Gene_ID = paste0("Gene", seq(40))
  )
)
DDLS <- createDDLSobject(
  sc.data = sce,
  sc.cell.ID.column = "Cell_ID",
  sc.gene.ID.column = "Gene_ID",
  sc.filt.genes.cluster = FALSE, 
  sc.log.FC = FALSE
)
probMatrix <- data.frame(
  Cell_Type = paste0("CellType", seq(4)),
  from = c(1, 1, 1, 30),
  to = c(15, 15, 50, 70)
)
DDLS <- generateBulkCellMatrix(
  object = DDLS,
  cell.ID.column = "Cell_ID",
  cell.type.column = "Cell_Type",
  prob.design = probMatrix,
  num.bulk.samples = 60
)
lapply(
  X = 1:6, FUN = function(x) {
      showProbPlot(
        DDLS,
        type.data = "train",
        set = x,
        type.plot = "boxplot"
      )
    }
  )
  
}
\seealso{
\code{\link{generateBulkCellMatrix}}
}
