% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daily_acticity_wrap_plot.R
\name{daily_activity_wrap_plot}
\alias{daily_activity_wrap_plot}
\title{Plot daily average over a period of time for a specific variable.}
\usage{
daily_activity_wrap_plot(
  df,
  activity,
  activity_alias,
  start,
  end,
  sampling_rate,
  ncols,
  save = "daily_wrap_plot"
)
}
\arguments{
\item{df}{The dataframe containing the activity data}

\item{activity}{the name of activity}

\item{activity_alias}{A string containing the name of the activity to be
shown on the graph.}

\item{start}{The start day (in "\%Y-\%m-\%d" format).}

\item{end}{The end day (in "\%Y-\%m-\%d" format).}

\item{sampling_rate}{the sampling rate of the data.}

\item{ncols}{the number of columns to spread the graphs on.
be the name of the saved image. it should contain the path and name without
the extension.}

\item{save}{if NULL, the image is not saved. Otherwise, this parameter will}
}
\value{
None
}
\description{
Takes an activity dataset as input and plot and save the daily average of the
specified activity column
}
\examples{
data("df516b_2")
df <- df516b_2
activity <- names(df)[2]
activity_alias <- 'Motion Index'
start <- "2020-05-01" #year-month-day
end <- "2020-05-07" #year-month-day
ncols <- 3
sampling_rate <- 30
my_dwp <- daily_activity_wrap_plot(df, activity, activity_alias, start, end, sampling_rate,
ncols)
}
