% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.R
\name{auto_context}
\alias{auto_context}
\title{Configure Automatic Context Calculation}
\usage{
auto_context(min = getOption("diffobj.context.auto.min"),
  max = getOption("diffobj.context.auto.max"))
}
\arguments{
\item{min}{integer(1L), positive, set to zero to allow any context}

\item{max}{integer(1L), set to negative to allow any context}
}
\value{
S4 object containing configuration parameters, for use as the
  \code{context} or parameter value in \code{\link[=diffPrint]{diff*}}
  methods
}
\description{
Helper functions to help define parameters for selecting an appropriate
\code{context} value.
}
\examples{
## `pager="off"` for CRAN compliance; you may omit in normal use
diffChr(letters, letters[-13], context=auto_context(0, 3), pager="off")
diffChr(letters, letters[-13], context=auto_context(0, 10), pager="off")
diffChr(
  letters, letters[-13], context=auto_context(0, 10), line.limit=3L,
  pager="off"
)
}

