\name{pktox}
\alias{pktox}

\title{
Dose finding method PKTOX.
}

\description{
The PKTOX model is essentially the PKLOGIT model with a probit regression model replacing the logistic regression, that is given by:
\deqn{p_T(z, \beta) = \Phi(-\beta_2 + \beta_3z)}
with a bivariate Uniform distribution as prior distribution for the parameters \eqn{\beta = (\beta_2, \beta_3)} and the hierarchical model of PK-toxicity for \eqn{z_i} given as:
\deqn{zi|\beta ~ N(\beta_0 + \beta_1 log(d_i), \nu^2)}
where \eqn{\beta = (\beta_0,\beta_1)} are the regression parameters and \eqn{\nu} is the standard deviation.

The default choices of the priors are:
\deqn{\beta \ \nu ~ N(m, \nu*beta0)}
\deqn{\nu ~ Beta(1,1)}
\deqn{m = (-log(CL_pop), 1)}  where Cl_pop=10 is the population clearance.
So \eqn{m = (-1, 1)}.
\deqn{\beta_2 ~ U(0, beta2mean)}
\deqn{\beta_3 ~ U(0, beta3mean)}
where default choices are beta0 = 10000, beta2mean = 20 and beta3mean = 10.

Finally, the PKTOX model has the following stopping rule in toxicity:
if
\deqn{P(p_T(dose) > theta) > prob}
then, no dose are suggested and the trial is stopped. 
}

\usage{
pktox(y, auc, doses, x, theta, prob = 0.9, options = list(nchains = 4, niter = 4000, 
    nadapt = 0.8), betapriors = c(10000, 20, 10), thetaL = NULL, 
    p0=NULL, L=NULL, deltaAUC=NULL)
}


\arguments{
\item{y}{
    A binary vector of patient's toxicity outcomes; TRUE indicates a toxicity, FALSE otherwise.
}
\item{doses}{
    A vector with the doses panel.
}
\item{x}{
    A vector with the dose level assigned to the patients.
}
\item{theta}{
    The toxicity target.
}
\item{prob}{
    The probability for the stopping rule.
}
\item{betapriors}{
    A vector with the value for the prior distribution of the regression parameters in the model; defaults to beta0 = 10000, beta2mean = 20 and beta3mean = 10.
}
\item{options}{
    A list with the Stan model's options; the number of chains, how many iterations for each chain and the number of warmup iterations.
    defaults to options <- list(nchains = 4,
                                niter = 4000,
                                nadapt = 0.8)}
\item{auc}{
    A vector with the computed AUC values of each patient for pktox, pkcrm, pklogit and pkpop; defaults to NULL.
}
\item{deltaAUC}{
    The difference between computed individual AUC and the AUC of the population at the same dose level (defined as an average); argument for pkcov; defaults to NULL.
}
\item{p0}{
    The skeleton of CRM for pkcrm; defaults to NULL (must be defined only in the PKCRM model).
}
\item{L}{
    The AUC threshold to be set before starting the trial for pklogit, pkcrm and pktox; defaults to NULL (must be defined only in the PKCRM model).
}
\item{thetaL}{
    A second threshold of AUC; must be defined only in the PKCRM model.
}         
}

\value{
A list is returned, consisting of determination of the next recommended dose and estimations of the model. Objects generated by pktox contain at least the following components:

\item{newDose}{The next maximum tolerated dose (MTD); equals to "NA" if the trial has stopped before the end, according to the stopping rules.}
\item{pstim}{The mean values of estimated probabilities of toxicity.}
\item{p_sum}{The summary of the estimated probabilities of toxicity.}
\item{parameters}{The estimated model's parameters.}
}

\references{
Ursino, M., et al, (2017) Dose-finding methods for Phase I clinical trials using pharmacokinetics in small populations, Biometrical Journal.

Whitehead, J., Zhou, Y., Hampson, L., Ledent, E., and Pereira, A. (2007) A bayesian approach for dose-escalation in a phase i clincial trial incorporating pharmacodynamic endpoints. Journal of Biopharmaceutical Statistics, 17 (6), 1117-1129.
}

\author{Artemis Toumazi \email{artemis.toumazi@inserm.fr},
        Moreno Ursino \email{moreno.ursino@inserm.fr},
        Sarah Zohar \email{sarah.zohar@inserm.fr}
        }


\seealso{
\code{\link{pklogit}}, \code{\link{sim.data}}, \code{\link{nsim}}, \code{\link{nextDose}}
}


\examples{
\dontrun{
    doses <- c(12.59972,34.65492,44.69007,60.80685,83.68946,100.37111)
    theta <- 0.2
    options <- list(nchains = 2,
            niter = 4000,
            nadapt = 0.8)
    AUCs <-  c(0.43, 1.4, 5.98, 7.98, 11.90, 3.45)
    x <- c(1,2,3,4,5,6)
    y <- c(FALSE,FALSE,FALSE,FALSE,TRUE,FALSE)

    res <- pktox(y, AUCs, doses, x, theta, options = options)
}
}


\keyword{models}
