\name{logistic_sim}
\alias{logistic_sim}
\alias{print.logistic_sim}
\title{Combination design Simulator using Logistic model}
\description{
\code{logistic_sim} is used to generate simulation replicates of Phase I clinical trial for combination studies where the toxicity and efficacy of both agents is assumed to increase with the dose using the design proposed by Riviere et al. entitled "A Bayesian dose-finding design for drug combination clinical trials based on the logistic model".
}
\usage{
logistic_sim(ndose_a1, ndose_a2, p_tox, target, target_min, target_max, 
prior_tox_a1, prior_tox_a2, n_cohort, cohort, tite=FALSE, time_full=0, 
poisson_rate=0, nsim, c_e=0.85, c_d=0.45, c_stop=0.95, n_min=4, seed = 14061991)
}
\arguments{
  \item{ndose_a1}{Number of dose levels for agent 1.}
  \item{ndose_a2}{Number of dose levels for agent 2.}
  \item{p_tox}{A matrix of the true toxicity probabilities associated with the combinations. True toxicity probabilities should be entered with agent 1 in column and agent 2 in row, with increasing toxicity probabilities with the column number, and decreasing toxicity probabilities with the row number (see examples and referenced papers).}
  \item{target}{Toxicity (probability) target (for dose allocation).}
  \item{target_min}{Minimum of the targeted toxicity interval (for dose recommendation).}
  \item{target_max}{Maximum of the targeted toxicity interval (for dose recommendation).}
  \item{prior_tox_a1}{A vector of initial guesses of toxicity probabilities associated with the doses of agent 1. Must be of same length as the columns of \code{p_tox}.}
  \item{prior_tox_a2}{A vector of initial guesses of toxicity probabilities associated with the doses of agent 2. Must be of same length as the rows of \code{p_tox}.}
  \item{n_cohort}{Total number of cohorts to include in the trial.}
  \item{cohort}{Cohort size.}
  \item{tite}{A boolean indicating if the toxicity is considered as a time-to-event outcome (TRUE), or as a binary outcome (default value FALSE).}
  \item{time_full}{Full follow-up time window. This argument is used only if tite=TRUE.}
  \item{poisson_rate}{A value indicating the rate for the Poisson process used to simulate patient arrival, i.e. expected number of arrivals per observation window. This argument is used only if tite=TRUE.}
  \item{nsim}{Number of simulations.}
  \item{c_e}{Probability threshold for dose-escalation. The default value is set at 0.85.}
  \item{c_d}{Probability threshold for dose-deescalation. The default value is set at 0.45.}  
  \item{c_stop}{Probability threshold for early trial termination. The default value is set at 0.95.}
  \item{n_min}{Minimum number of patients to be included before possible early trial termination. The default value is set at 4.}
  \item{seed}{Seed of the random number generator. Default value is set at 14061991.} 
}
\value{
An object of class "logistic_sim" is returned, consisting of the operating characteristics of the design specified. Objects generated by \code{logistic_sim} contain at least the following components: 
\item{p_tox}{True toxicities.}
\item{}{Percentage of Selection.}
\item{}{Number of patients at each combination.}
\item{}{Number of toxicities at each combination.}
\item{inconc}{Percentage of inclusive trials.}
\item{n_min}{Minimum number of cohorts to stop the trial.}
\item{nsim}{Number of simulations.}
\item{cohort}{Cohort size.}
\item{n_cohort}{Number of cohort planned.}
\item{}{Total patients accrued.}
\item{target}{Toxicity target.}
\item{}{Targeted toxicity interval.}
\item{prior_tox_a1}{Prior toxicity probabilities for agent 1.}
\item{prior_tox_a2}{Prior toxicity probabilities for agent 2.}
\item{c_e}{Escalation threshold.}
\item{c_d}{Deescalation threshold.}
\item{c_stop}{Stopping threshold.}
\item{tite}{Type of outcome for toxicity (time-to-event or binary).}
\item{time_full}{If toxicity is a time-to-event, full follow-up time is also reminded.}
\item{poisson_rate}{If toxicity is a time-to-event, rate for Poisson process is also reminded.}
}
\references{
Riviere, M-K., Yuan, Y., Dubois, F., and Zohar, S. (2014). A Bayesian dose-finding design for drug combination clinical trials based on the logistic model. Pharmaceutical Statistics.
}
\author{Jacques-Henri Jourdan and Marie-Karelle Riviere-Jourdan \email{marie-karelle.riviere@inserm.fr}}
\seealso{
  \code{\link{logistic_next}}.
}
\examples{
p_tox_sc1 = matrix(c(0.15,0.10,0.05,0.30,0.15,0.10,0.45,0.30,0.15,0.50,0.45,
                     0.30,0.60,0.55,0.45),nrow=3,ncol=5)
p_tox_sc6 = matrix(c(0.15,0.09,0.05,0.30,0.12,0.08,0.45,0.15,0.10,0.50,0.30,
                     0.13,0.60,0.45,0.15),nrow=3,ncol=5)
prior_a1 = c(0.12, 0.2, 0.3, 0.4, 0.5)
prior_a2 = c(0.2, 0.3, 0.4)

# UNCOMMENT THOSE EXAMPLES
#log_sim1 = logistic_sim(ndose_a1=5, ndose_a2=3, p_tox=p_tox_sc1, target=0.30, 
#  target_min=0.20, target_max=0.40, prior_tox_a1=prior_a1, prior_tox_a2=prior_a2, 
#  n_cohort=20, cohort=3, tite=FALSE, nsim=2, c_e=0.85, c_d=0.45, c_stop=0.95, 
#  n_min=4, seed = 14061991)
                        
#log_sim1
                        
#log_sim2 = logistic_sim(ndose_a1=5, ndose_a2=3, p_tox=p_tox_sc6, target=0.30, 
#  target_min=0.20, target_max=0.40, prior_tox_a1=prior_a1, prior_tox_a2=prior_a2, 
#  n_cohort=20, cohort=3, nsim=2)  

#log_sim2

# Dummy example, running quickly
useless = logistic_sim(ndose_a1=3, ndose_a2=2,
  p_tox=matrix(c(0.15,0.05,0.30,0.15,0.45,0.30),nrow=2), target=0.30,
  target_min=0.20, target_max=0.40, prior_tox_a1=c(0.2,0.3,0.4),
  prior_tox_a2=c(0.2,0.3), n_cohort=2, cohort=2, nsim=1)
}
