% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dexter.R
\name{ability}
\alias{ability}
\title{Estimate abilities}
\usage{
ability(dataSrc, parms, predicate = NULL, method = c("MLE", "EAP"),
  use_draw = NULL, person_level = TRUE)
}
\arguments{
\item{dataSrc}{Data source: a dexter project db handle or a data.frame}

\item{parms}{An object returned by function \code{fit_enorm} and containing
parameter estimates}

\item{predicate}{An optional expression to subset data, if NULL all data is used}

\item{method}{If ability will be estimated with maximum likelihood (MLE). Otherwise, 
we produce a Bayesian expected a posteriori (EAP) estimate.}

\item{use_draw}{When the ENORM was fitted with a Gibbs sampler (this is 
recognised automatically), the number of the random draw (iteration) to use 
in generating the PV. If NULL, all draws will be averaged. If outside range,
the last iteration will be used.}

\item{person_level}{If TRUE, return results per person, otherwise just
the score transformation table.}
}
\value{
Depends on \code{person_level}
}
\description{
Computes MLE of ability and optionally attaches them to person data by sum score
}
\examples{
\dontrun{
db = start_new_project(verbAggrRules, "verbAggression.db")
add_booklet(db, verbAggrData, "agg")
f = fit_enorm(db)
aa = ability(db,f,method="MLE",person_level = FALSE)
bb = ability(db,f,method="EAP",person_level = FALSE)
plot(bb$sumScore, bb$theta, xlab="test-score", ylab="ability est.", pch=19, cex=0.7)
points(aa$sumScore, aa$theta, col="red", pch=19, cex=0.7)
legend("topleft", legend = c("EAP", "MLE"), bty = "n",
    lwd = 1, cex = 0.7, col = c("black", "red"), lty=c(0,0), pch = c(19,19))
}

}
