% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detconstruct.R
\name{det.construct}
\alias{det.construct}
\title{Distribution Element Tree (DET) Construction}
\usage{
det.construct(dta, mode = 2, lb = NA, ub = NA, alphag = 0.001,
  alphad = 0.001, progress = TRUE, cores = 0)
}
\arguments{
\item{dta}{matrix with \code{d} rows representing components or dimensions and \code{n} columns corresponding to data points or samples.}

\item{mode}{order of distribution elements applied, default is \code{mode = 2}. Use \code{+/-1} for constant or \code{+/-2} for linear elements. \code{mode > 0} and \code{mode < 0} lead to equal-size and -score splits, respectively, in the element-refinement process.}

\item{lb, ub}{vectors of length \code{d} with lower and upper sample-space bounds. If not provided or set to \code{NA} or \code{0}, the bounds are determined from the data \code{dta}. If bounds are provided or given as \code{0}, the data is not pre-whitened before the DET is computed.}

\item{alphag, alphad}{significance levels for goodness-of-fit and independence tests, respectively, in element refinement or splitting process. Default is \code{alphag = alphad = 1.0e-3}. \code{alphad} is irrelevant for univariate data \code{dta} with \code{d = 1}.}

\item{progress}{optional logical, if set to \code{TRUE}, a progress report about the DET construction process is provided.}

\item{cores}{for large datasets, \code{cores > 1} allows for accelerated tree construction with parallel branch splitting. The default is \code{cores = 0}, which allocates half of the available cores (see \code{\link[parallel]{detectCores}}). \code{cores = 1} corresponds to serial tree construction.}
}
\value{
A DET object which describes the DET structure and pre-white transform is returned.
}
\description{
The function \code{det.construct} generates a distribution element tree DET from available data. The DET can be used firstly in connection with \code{\link{det.query}} for density estimation. Secondly, with \code{\link{det.rnd}}, DETs can be used for smooth bootstrapping or more specifically conditional or unconditional random number generation.
}
\examples{
## Gaussian data
require(stats)
det <- det.construct(t(rnorm(1e5)), cores = 2) # default linear elements
x <- t(seq(-4,4,0.05)); p <- det.query(det, x, cores = 2); plot(x, p, type = "l")

## piecewise uniform data with peaks
x <- matrix(c(rep(0,1e3),rep(1,1e3),2*runif(1e4),
              rep(0,5e2),rep(1,25e2),2*runif(9e3)), nrow = 2, byrow = TRUE)
det <- det.construct(x, mode = 1, lb = 0, ub = 0, cores = 2) # constant elements
}
\references{
Meyer, D.W. (2016) \url{http://arxiv.org/abs/1610.00345} or Meyer, D.W., Statistics and Computing (2017) \url{https://doi.org/10.1007/s11222-017-9751-9} and Meyer, D.W. (2017) \url{http://arxiv.org/abs/1711.04632}
}
