% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tour_path.R
\name{tour_path}
\alias{tour_path}
\title{Generate a tour path for a detour object}
\usage{
tour_path(
  x,
  tour_path = grand_tour(2),
  start = NULL,
  aps = 1,
  fps = 30,
  max_bases = 10
)
}
\arguments{
\item{x}{a \code{detour} object}

\item{tour_path}{tour path generator, defaults to 2d grand tour}

\item{start}{projection to start at, if not specified, uses default
associated with tour path}

\item{aps}{target angular velocity (in radians per second)}

\item{fps}{target frames per second}

\item{max_bases}{the maximum number of bases to generate}
}
\value{
A \code{detour} object containing information about the tour path and
its parameters
}
\description{
This function takes a \code{detour} object as an input, and generates a
sequence of projection matrices for the tour. The return value is another
\code{detour} object with the tour path and other metadata attached. This can
then be passed to a \verb{show_*}#' function to generate the detour
visualisation.
}
