% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simLMM.R
\name{simLMM}
\alias{simLMM}
\title{Simulate data from a linear mixed-effects model}
\usage{
simLMM(
  formula,
  data = NULL,
  Fixef,
  VC_sd,
  CP = 0,
  LMM = NULL,
  empirical = FALSE,
  verbose = TRUE,
  family = "gaussian"
)
}
\arguments{
\item{formula}{A formula as used in a call to the \code{lmer} function: a one-sided linear formula object describing both the fixed-effects and random-effects part of the model, with no response variable to the left of the \code{~} operator.}

\item{data}{a data frame containing the variables named in \code{formula}.}

\item{Fixef}{a vector of all fixed-effect model parameters.}

\item{VC_sd}{standard deviations of the variance components for the random effects. This is a list of vectors, where different list entries reflect different grouping structures, and each vector contains standard deviations of variance components (random intercepts and random slopes) for one grouping factor. The last list entry is the standard deviation of the residual noise term.}

\item{CP}{correlation parameters of the random effects. If \code{CP} is a single number, then all CP are set to this same value. If \code{CP} is a vector of length equal to the number of grouping factor, then each vector entry specifies one fixed value for all CP associated with this grouping factor. Otherwise, \code{CP} can be a list of correlation matrices, which specifies a full correlation matrix for each grouping structure.}

\item{LMM}{if a \code{lmerMod} object containing a fitted \code{lmer} model is provided, then \code{simLMM} uses the estimated model parameters for data simulation.}

\item{empirical}{logical. If true, \code{Fixef} specify the empirical not population fixed effects parameters. \code{empirical=TRUE} does not work for residual Bernoulli noise, and not if continuous covariates are used.}

\item{verbose}{logical. If \code{TRUE} (default), then information about the used model parameters is provided. If \code{FALSE}, then no output is generated.}

\item{family}{string specifying the response distribution: \code{"gaussian"} (default) assumes a normal distribution, \code{binomial} specifies a Bernoulli distribution with a logit link function, \code{"lognormal"} specifies a log-normal distribution; with \code{"lp"}, only the linear predictor is generated with no residual noise.}
}
\description{
This function simulates artificial data from a linear mixed-effects model.
}
\examples{

design <-
  fixed.factor("X", levels=c("X1", "X2")) +
  random.factor("Subj", instances=30)
dat <- design.codes(design)
contrasts(dat$X) <- c(-1, +1)

dat$ysim <- simLMM(formula = ~ 1 + X + (1 + X | Subj),
                   data = dat,
                   Fixef = c(200, 10),
                   VC_sd = list(c(30,10), 50),
                   CP = 0.3,
                   empirical = TRUE)

dat$Xn <- ifelse(dat$X=="X1",-1,1)
# lme4::lmer(ysim ~ Xn + (Xn || Subj), data=dat, control=lmerControl(calc.derivs=FALSE))

}
