### Check the correct estimation of autocovariances in Cpp via 'acovCpp'

Xt <- c(12.8433856964746, 11.6161505776814, 11.3094186367253, 10.7116011400713, 10.1862273446052, 10.0708742587288, 8.98039903644311, 10.2107197146335, 11.6497704403272, 11.0233889301354, 12.3311187036587, 13.6151547745729, 13.3787689699471, 14.0427281985119, 15.0856060570139, 15.7505720653137, 16.0548312406384, 16.0666196490345, 15.3916808705163, 14.3672580903331, 13.4536283303508, 12.4625973518189, 12.0985473787934, 11.0296281745773, 13.1869975117585, 15.4533382392052, 14.2282091833928, 12.9253073014742, 12.3096173397592, 13.0933695793561, 13.4019721982456, 13.5230145195308, 13.4942226653202, 13.3188120307585, 14.6003354768997, 14.6087649901778, 15.5597206047244, 14.0312869212916, 13.5621381924251, 13.8396578533602, 13.8956291880184, 14.1445506987448, 13.518681777392, 12.8087081339503, 11.7109166188234, 10.5465627151473, 11.0802269287696, 12.2861329494702, 12.8074021806744, 13.8439511077171, 16.131984194969, 15.7564001132353, 12.4047956205956, 12.4645110210588, 12.4488262143899, 11.6015693523144, 12.7326656080831, 13.0708786034555, 11.7165108066388, 11.702502188269, 12.0735119092239, 12.3177768411371, 12.9406062828722, 12.8104045667813, 13.3563297293695, 13.3811325229993, 13.5183314491059, 14.6555620094813, 15.1724944040454, 14.4424052427174, 15.0255254955877, 16.0157755120991, 16.1861917459585, 15.7732644370364, 14.4627448974418, 15.1006208387196, 14.5805012242216, 16.0235540563981, 17.7727649621722, 16.9015404275126, 14.6168072194018, 12.9381480397286, 12.8883840551169, 12.8336188146977, 12.4426446316595, 11.5144613751978, 11.469285954197, 11.1510818360764, 9.67536311393678, 9.48855669117392, 11.3008730327386, 11.724762464839, 12.4576245663082, 11.3364366492391, 11.0010023347982, 12.1223278555399, 12.9764864630164, 13.2697933993438, 12.6309874683097, 11.6016338776306, 10.6021627507197, 10.9570961273014, 10.7113159734763, 10.4636264306403, 10.7531675873996, 13.1730332203128, 13.4211043551396, 13.2341846700349, 13.3895834047305, 12.3798321739631, 12.0436461185855, 13.7694490983714, 14.7423938511509, 14.5166606443382, 13.6897820796936, 11.2483518180752, 11.9085598752965, 11.3710204484898, 11.8993417893578, 14.5386165772066, 13.6176902276816, 13.4422209142659, 13.428249318271, 11.626531618943, 9.7678323999056, 8.40861267946845, 8.48435426667032, 8.14183914058817, 9.5863263788896, 13.0844957922363, 12.8521710487931, 13.0707433436127, 14.2424320052674, 14.6164261031378, 13.3192229533945, 12.629815156607, 12.4307489711393, 13.0543161454329, 12.9770773123094, 13.8047081272503, 13.707201524651, 14.3904621039515, 13.4805021988897, 11.5816077911316, 14.6480877663555, 15.3873238157596, 14.7909254684922, 15.0693312977488, 14.3130361197323, 14.2240970152719, 14.5142634602322, 14.0590861782134, 13.7289631044538, 13.5388534361419, 15.5186156774463, 15.1159208274476, 13.0444802640023, 12.5509264504353, 13.0450234643334, 13.6532802786651, 13.2471926018096, 11.91052602094, 12.9988903237619, 13.3111654267245, 12.207477742077, 11.8061984191861, 11.8790232146112, 13.2566485927672, 13.849351451991, 14.4209684476769, 13.9024127887938, 13.6264882531511, 13.2510785205058, 13.1379955367822, 12.2785252818568, 10.766484484983, 12.8083517575721, 14.4951617463469, 13.1256962726541, 11.881185793365, 10.7557670124179, 13.0651072152776, 15.4873932015697, 15.1622366726192, 14.9541872017174, 14.2551881228993, 13.2252148174545, 12.1609240870601, 11.4537281745575, 13.3012085557972, 14.0122715976409, 13.8308212922335, 13.9148849523763, 15.0247390599483, 14.5474914502617, 12.8627049493188, 14.1133368217303, 14.2060210245075, 12.9305671387628, 11.3835908932807, 9.99566134353704, 9.71063160001905, 11.0584411975309, 13.0897498857846, 14.3553373433497, 13.9688730201673, 13.5861324029541, 12.7655711870801, 11.796383437542, 12.7135098244693, 12.2561895480134, 13.9568303598001, 14.5871086406405, 14.3103550780946, 13.3159902632413, 12.3075406421358, 10.9410679723082, 10.7473141260904, 11.7806395990014, 12.7102432659246, 12.2077859711731, 11.2960599654398, 10.940732272038, 12.8334739011015, 12.5241584450285, 11.9492075068069, 14.1072812792536, 14.6553029209882, 12.7783838982059, 11.5301789415594, 12.1542005203594, 12.3050674820343, 11.7938694380393, 11.5608531907242, 11.9411352635819, 13.9325517792228, 14.39347551889, 15.0419498033051, 15.6305187260399, 15.073100270547, 12.8914482387393, 11.6664454481197, 11.346082701769, 11.6744770974306, 13.425909862249, 16.2713152162388, 18.0140411972665, 17.1804684032495, 14.1332250045525, 12.5562139413362, 12.6141670499728, 13.649533550585, 14.8697079559275, 15.5043689828079, 13.7299386528743, 13.6929629277456, 13.4933383558114, 13.3268609410156, 13.4207551859653, 13.7899709837331, 13.8217380539245, 11.9500790315746, 12.1978137380828, 13.2227441673944, 13.1132825760727, 13.0946165016584, 13.2893424520527, 13.5205785076821, 15.1457608556355, 15.1334053030001, 14.581923906518, 15.389763299574, 16.3412072696133, 17.0411987107981, 15.8540026516893, 16.7415505859456, 16.7170276462385, 17.5321216325389, 15.7850083790999, 14.3250381087088, 15.2179330402425, 14.4922682264316, 12.964277696673, 11.6901111999553, 10.5912952088265, 10.3804904733288, 11.3089427376989, 9.99763900494803, 10.1332224878756, 12.3659210046156, 15.2420562446796, 16.9194023725966, 17.1809444207138, 14.6083180772833, 12.6909507465344, 12.1608657119881, 12.9701066728572, 13.2551652883747, 11.8971314068003, 13.3131033788242)

acf_b <- as.matrix(stats::acf(Xt, lag.max = 40, type = "covariance", plot = FALSE)$acf)

test_that("Autocovariances are estimated correctly for various lagMax inputs", {
          
  expect_equal(acovCpp(Xt, lagMax = 40), acf_b)
  expect_equal(acovCpp(Xt, lagMax = 30), acf_b[1:31, , drop = FALSE]) 
  expect_equal(acovCpp(Xt, lagMax = 25), acf_b[1:26, , drop = FALSE]) 
  expect_equal(acovCpp(Xt, lagMax = 15), acf_b[1:16, , drop = FALSE])   
  expect_equal(acovCpp(Xt, lagMax = 1), acf_b[1:2, , drop = FALSE])
  expect_equal(acovCpp(Xt, lagMax = 0), acf_b[1, , drop = FALSE])     
})

### Test that the cf0Cpp returns correct value

Xt2 <- c(-23.1049234861522, -23.7189324031988, -21.9270498740018, -24.5125182004838, -22.0496281423709, -24.512990018751, -19.8406085655617, -26.0014740650908, -21.0046453796722, -26.3739274693632, -19.3025276644544, -27.1117501735363, -20.671484658439, -23.4358587808939, -23.7767700853933, -24.1482828969737, -19.7221117222274, -28.726880774778, -17.3996684650996, -26.3593885902755, -21.95802047801, -23.1396146806512, -22.8552828608614, -22.4502440386768, -23.591041361431, -23.2432045200671, -21.9613228884666, -23.5544476505337, -24.1187668570171, -23.3193661170159, -22.0857724610978, -24.1640604220033, -23.2037156297724, -22.4506988233631, -24.9164726898902, -21.0072445025072, -25.27047041145, -20.3110422440216, -23.1063634251196, -25.2237694166838, -20.0977076155349, -24.9052870268287, -22.3190681694094, -24.0652015433178, -20.6222280258116, -27.6275520535869, -19.5711794449647, -26.6854204363856, -18.4764705337551, -27.2248307784893, -20.6419379382047, -21.3742633694555, -25.9500751463019, -21.5236780755114, -23.6816854410726, -24.4111774370722, -20.9076608409999, -24.9759519337161, -21.2702269233286, -25.5974743508729, -21.883566478568, -24.1334262072046, -22.7978838964115, -21.628436519282, -23.2004738580363, -23.9761330333177, -22.7671974607428, -23.4825323276094, -22.5984714776096, -23.3887839708988, -22.6562689494558, -24.30230787031, -22.7319414090802, -21.7371151554876, -25.201185584135, -21.0518107153284, -24.7422258806862, -22.8798060087687, -22.1841491883751, -23.8635216493502, -21.2523039259888, -24.9758193452871, -22.1772020088134, -23.3018908014248, -24.2834155446906, -22.5147073475925, -22.581484578849, -24.0512183215993, -22.333547670621, -23.7187578668111, -23.2597712572958, -24.6815924695881, -20.6347059715705, -24.2384837973421, -23.9725973310341, -20.3624210321425, -25.3723518130424, -20.3602908477201, -26.6457870253352, -19.97258255829, -25.4725968123129, -20.6206678200298, -25.7956458098327, -20.9352158211132, -26.3889592379885, -20.6860204019066, -24.275941113565, -23.0456796547253, -22.8284329813097, -23.7362381441027, -21.813740176004, -23.1353586361284, -24.4819945218924, -22.0283896868663, -22.2568476815265, -26.6090105063, -19.8640688102389, -23.1405286528191, -21.9103920160341, -24.8729252999581, -22.800858902318, -22.7121368735801, -24.1070072941862, -20.6158904138047, -26.3717680071855, -20.0336094719099, -24.8130790926988, -22.9682798330911, -21.9619243549822, -25.0703452631819, -20.7165535006605, -23.9868708312611, -24.0159641570522, -20.8566085878922, -25.7139043801777, -20.7311471098325, -24.703536245047, -22.5056397509497, -23.0343511111683, -24.5104365826049, -21.6336158016496, -23.2326096710876, -25.5941932953006, -21.7549285560332, -24.4595244746946, -23.1564537830607, -21.8463544654884, -25.1802717435623, -23.3118926899574, -22.5069703394458, -23.5869716313225, -21.7070167585587, -25.6072331418968, -19.6317714769341, -25.7100418783868, -21.109799885308, -25.5268418294167, -19.021280004353, -27.0962087689991, -22.0454160298304, -23.129616458422, -24.9117843141404, -21.1750390605224, -24.7144446029306, -21.0769455859504, -23.847556749299, -23.8075633332606, -21.435544315892, -23.2438503033944, -24.495610347301, -22.3834051209673, -22.6246358689195, -23.5750961033892, -22.3101817521552, -22.5225759591659, -23.8194558562812, -21.738221190216, -23.9561903395993, -22.3784991036402, -23.4357763841719, -21.7666754457138, -25.68124871394, -21.8971786925442, -22.7974375472431, -23.7274563827615, -22.5269304883154, -22.7968738868503, -22.9295319199414, -23.8586456833273, -22.7501566389871, -23.1150198092026, -22.0632676487674, -23.9312010538312, -21.2981619948345, -25.0854272294475, -20.580714898956, -24.5433310623239, -21.9190859509818, -23.8179808579843, -23.0846461499427, -23.0798440056381, -22.8301949457603, -23.3546723951428, -22.0029493003535, -24.4488648471321, -22.1715129670021, -24.1990715498703, -22.2268266998513, -23.7108187881363, -24.9517798010521, -22.0117179495281, -23.2518684966751, -23.2227323722159, -24.082314780224, -23.8034831657825, -21.9661619158442, -23.0630062832581, -21.6794048526389, -25.0194927128259, -20.2439418635395, -25.7628109582002, -21.1620113038183, -24.1895328261083, -23.3703169236595, -22.5272077437028, -22.5666477741684, -24.6772961943305, -21.9426358404306, -24.8971226272139, -20.9137765892713, -24.3827327033457, -21.7661396476284, -25.5776859537891, -20.6484797818344, -25.8137393617431, -20.7287382496709, -23.4170669808663, -24.0528903603309, -21.4645307833624, -25.3528386961994, -21.6267068310689, -23.45331936244, -23.7511495920432, -24.0076039854863, -20.3480263573735, -25.2986085295653, -22.3247920888043, -25.3449046048876, -18.6293176115141, -23.7902117363682, -24.1045567878225, -21.6507438046908, -23.3148223483979, -24.2637089456972, -22.2856977507992, -25.2215344963075, -21.487943566534, -23.2377406044041, -23.605502457601, -22.8150018192419, -23.3049525109416, -24.7639204490852, -20.1657922601609, -27.0162532739386, -19.8454464261909, -25.7124658825174, -21.2705859680646, -22.8113269691909, -24.6141140118496, -22.5321878284595, -24.6255737171663, -22.0779694821229, -24.5787570290761, -21.0738315297146, -25.5852952733318, -20.6247491506357, -25.131124099917, -23.0385615660449, -23.2168335995358, -21.7378001324059, -23.5930200488902, -21.2008507344535, -25.4357714314326, -22.9589966577794, -23.2192059595785, -22.2238588099473, -22.0174067505622, -24.6978743186141, -20.8961057135615, -24.4448381083789, -23.7107455985982, -22.2595449221874, -22.2975006919887, -23.4382841741858, -22.8374529913001, -23.038566731497, -23.87296571085, -23.6326066656445, -20.7720568865454, -26.7974925665008, -20.7405413773218, -23.653208083502, -24.2894313871981, -22.1881711675393, -24.6451444828686, -20.8063355508718, -24.5695838766161, -21.8725631014141, -23.7276834035014, -22.3246082572429, -23.2820406011489, -25.2609113818553, -20.7518476157241, -24.5568346757613, -21.4117714305953, -25.8315841759125, -21.0937482286745, -25.328219135771, -19.946184896875, -24.557218095333, -21.9318068995123, -25.533976915598, -20.3330623510563, -24.112383226248, -22.7986153540804, -23.9610490754079, -23.3003292213778, -23.08201322029, -22.0650909920676, -24.6135215839093, -21.5970894011324, -22.970899093507, -23.2595085919108, -21.9128386744236, -26.3149291213006, -20.2794359934732, -24.8689886452197, -21.3156526664838, -25.8075444007946, -19.813930753232, -25.4959508242989, -21.3127234474672, -23.9745118019703, -22.8584425743003, -22.2853648795522, -23.4847878598316, -23.3049727591514, -21.8410373621695, -24.2089036712055, -21.8012953731898) 
Xt3 <- c(12.8801548399769, 10.5320712838867, 8.14019612881742, 7.37156462885537, 9.18144540126671, 11.8344910313574, 13.0979953152307, 11.5597895009732, 8.81282141601059, 7.14856231979085, 9.3882013714678, 9.95800481170296, 10.0892433327714, 10.1552886085182, 11.3802993427603, 11.3346376679242, 10.3895483150836, 8.80022591002552, 8.52823762733722, 10.6196841333495, 14.0533146087286, 16.4641371385647, 18.3374653719177, 19.6516872522837, 18.7430179873464, 16.9088589750924, 13.9876517066673, 11.1332397616772, 10.7546694380539, 11.6061697894855, 12.2876637898758, 11.2190119913447, 9.2003570195169, 7.30550967492836, 6.90300106386863, 6.48806729821255, 6.87221714412673, 6.75224207579294, 8.39248424427608, 10.8077938871734, 11.0677101643313, 10.6585784074774, 10.0353843835132, 9.81870593744773, 10.1145148661481, 9.22194092299333, 7.5007407787164, 7.01691792271023, 9.11881331536102, 12.083856963271, 12.7593057613652, 12.8088065458065, 12.5938309386539, 12.1412471481268, 11.8531138840581, 13.9789044597844, 14.2734208457648, 12.8062898036645, 9.81875405353163, 8.06183849295032, 9.0772145956244, 11.6515494417031, 11.1732255846176, 9.8849332709516, 11.113661340995, 11.8044264086012, 11.1392871040161, 10.361546419925, 10.2012372804137, 10.8610372951322, 12.5496666511523, 13.2903900031117, 12.9475868344786, 14.7067129046346, 16.272918406218, 15.9722293918065, 13.3085166479951, 10.6588383933237, 9.12758688819681, 8.42572738679721, 7.75779296972113, 6.78699437174108, 5.7884130349151, 5.46432919870984, 7.36125976327453, 10.397746251822, 11.6822684548691, 9.83772211980959, 7.15622586056465, 5.56787159439167, 5.52793725332814, 5.68595159307327, 8.10108333576807, 10.2586602457732, 9.57265396973004, 8.39409222594057, 7.03371444727374, 6.51574960467154, 7.21274078515142, 8.42475688039539, 7.69610625026672, 6.99302108365803, 7.63605965540698, 7.01122475384567, 7.34174641367972, 9.24299605780999, 12.8050185925111, 15.0852984919578, 15.0011060732883, 13.9718338417561, 12.7734759121418, 9.81282452107018, 5.76578833658267, 3.79360099349458, 3.49841509691921, 4.26675381562275, 3.52237208175354, 1.63472169337207, 0.432014807690271, 2.0696972495765, 3.68397570196172, 4.01428398469287, 4.82371594737489, 5.78792347235204, 6.84879114944539, 10.1762922796401, 11.6104677937592, 10.7618125979902, 9.44994676639497, 10.1175508374641, 10.3790346316081, 9.74404336543422, 10.1591196579351, 9.58701587599365, 10.3407926821913, 12.1230127731516, 11.6225490946595, 10.7879076476704, 10.2359090815422, 10.033172324837, 9.92340522336843, 10.7913482566763, 10.1514650550278, 8.41194183474497, 7.35098348360988, 6.1910903149293, 4.73148070579421, 4.43938745414496, 5.17170938545353, 3.68164842642178, 3.74026214839384, 5.76972501692071, 9.87360797568676, 13.5553622259959, 14.1611511147891, 15.9804520089294, 19.90274267689, 19.8517342067554, 17.4787888435318, 14.9840251844771, 12.9296176793345, 11.7417045579118, 9.67282357203259, 8.31915576579552, 9.91445860142892, 11.3351464291468, 11.2550115612252, 12.15277128173, 13.6988603580713, 12.348066843022, 10.4575961506314, 11.2805700621839, 13.6410503050939, 15.0061497550048, 15.4041513533697, 13.5983189941207, 11.6182926911652, 9.60825363669091, 7.73189985835339, 7.97577121826914, 7.78263461715823, 7.61363543714059, 8.4917916677008, 9.33660701990728, 11.5423477605476, 12.0671404692202, 11.7363513231357, 11.4115129894854, 10.5650844738239, 10.3010880603465, 9.27332603251379, 6.96186474394917, 5.24235585433902, 6.84114975209255, 9.09925642524124, 10.4275410724479, 10.7623607181001, 10.9804011820883, 10.0821532274211, 10.1733261408283)

test_that("The correctness of the cf0Cpp output", {
  expect_equal(cf0Cpp(Xt), 11.629515742154686)
  expect_equal(cf0Cpp(Xt2), 0.081835576490481)
  expect_equal(cf0Cpp(Xt3), 54.650244770541555)  
})
