% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoundingCovariateEffects.R
\name{get.test.statistic}
\alias{get.test.statistic}
\title{Obtain the test statistic by minimizing the S-function over the
feasible region \eqn{\beta(r)}.}
\usage{
get.test.statistic(
  beta.init,
  data,
  par.space,
  t,
  hp,
  c,
  r,
  inst.func.evals = NULL
)
}
\arguments{
\item{beta.init}{Starting value of minimization algorithm.}

\item{data}{Data frame.}

\item{par.space}{Matrix containing the bounds on the parameter space.}

\item{t}{Time point at which to evaluate beta. Also allowed to
be a vector of time points (used in estimating the model under assumed time-
independent coefficients).}

\item{hp}{List of hyperparameters.}

\item{c}{Projection vector}

\item{r}{hypothesised value of the projection.}

\item{inst.func.evals}{Matrix of precomputed instrumental function
evaluations for each observation in the data set. If \code{NULL}, the
evaluations will be computed during execution of this function. Default is
\code{inst.func.evals = NULL}.}
}
\value{
A list containing the value of the test statistic and the parameter
at which this value was attained.
}
\description{
Obtain the test statistic by minimizing the S-function over the
feasible region \eqn{\beta(r)}.
}
