% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseInput.R
\name{parseInput}
\alias{parseInput}
\title{Checks input for errors}
\usage{
parseInput(genes = genes, classes = classes, nsamples = nsamples,
  groupBy = groupBy, includeGenes = includeGenes,
  includeClasses = includeClasses, geneId = geneId, signifP = signifP,
  roundExpected = roundExpected, probTable = NULL)
}
\arguments{
\item{genes}{A vector of genes containing de novo variants.}

\item{classes}{A vector of classes of de novo variants.  Standard supported
classes are "syn" (synonymous), "mis" (missense), "non" (nonsense),
"splice" (splice), "frameshift" (frameshift) and "lof" (loss of function =
non + splice + frameshift). Additional classes that are supported by the
code, but are not included in the built-in probability tables, are
"stoploss","startloss", "misD" (damaging missense).  These labels may be
used for user-supplied probability tables. If "misD" is present, then "mis"
(in the input) implies non-damaging missense.}

\item{nsamples}{Number of individuals considered in de novo analysis.}

\item{groupBy}{Results can be tabulated by "gene", or by variant "class"}

\item{includeGenes}{Genes to include in analysis. "all" or a vector of gene
names.}

\item{includeClasses}{Determines which variant classes are tabulated in
output.  In addition to the input classes, summaries can be produced for
"prot" (protein-altering = mis + lof), "all", and "protD" (protein damaging
= misD + lof, only available if misD included in user-specified probability
table).  If "misD" is present, then "mis" will return statistics for all
missense.  Non-damaging missense are not analysed separately.}

\item{geneId}{Gene identifier used. One of "hgncID", "hgncSymbol",
"enstID", "ensgID" or "geneName" (default, equals ensembl "external_gene_name")}

\item{signifP}{Number of significant figures used to round p-values in
output.}

\item{roundExpected}{Number of decimal places used to round expected burdens
in output.}

\item{probTable}{Probability table. A user-defined table of probabilities can
be provided here, to replace the probability table included in the package.}
}
\value{
warning or error if any invalid input, else assigns variables back to
  parent function
}
\description{
An internal function to check inputs
}

