% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_methods.R
\name{compare_methods}
\alias{compare_methods}
\title{compare_methods}
\usage{
compare_methods(formula, dataset, k = 3, repeats = 2, use_caret = TRUE,
  ANN_neurons = 1, MT_M = 4, MT_N = F, MT_U = F, MT_R = F,
  BMT_P = 100, BMT_I = 100, BMT_M = 4, BMT_N = F, BMT_U = F,
  BMT_R = F, RF_mtry = 0, RF_maxnodes = 4, RF_ntree = 200,
  multiply = 5, returns = c("Calibration", "Validation"), digits = 3)
}
\arguments{
\item{formula}{an object of class "formula" (or one that can be coerced
to that class): a symbolic description of the model to be fitted.}

\item{dataset}{a data frame with dependent and independent variables as
columns and (optional) years as row names.}

\item{k}{number of folds for cross-validation}

\item{repeats}{number of cross-validation repeats. Should be equal or more
than 2.}

\item{use_caret}{if set to TRUE, the package caret will be used to tune parameters
for regression methods}

\item{ANN_neurons}{positive integer that indicates the number of neurons used
for brnn method}

\item{MT_M}{minimum number of instances used by model trees}

\item{MT_N}{unpruned (argument for model trees)}

\item{MT_U}{unsmoothed (argument for model trees)}

\item{MT_R}{use regression trees (argument for model trees)}

\item{BMT_P}{bagSizePercent (argument for bagging of model trees)}

\item{BMT_I}{number of iterations (argument for bagging of model trees)}

\item{BMT_M}{minimum number of instances used by model trees}

\item{BMT_N}{unpruned (argument for bagging of model trees)}

\item{BMT_U}{unsmoothed (argument for bagging of model trees)}

\item{BMT_R}{use regression trees (argument for bagging of model trees)}

\item{RF_mtry}{Number of variables randomly sampled as candidates at each
split (argument for random forest)}

\item{RF_maxnodes}{Maximum number of terminal nodes trees in the forest can
have (argument for random forest)}

\item{RF_ntree}{Number of trees to grow (argument for random forest)}

\item{multiply}{an intiger that will be used to change the seed options
for different repeats. set.seed(multiply*5)}

\item{returns}{A character vector that specifies, whether a calibration and/ or
validation results should be returned.}

\item{digits}{intiger of number of digits to be displayed in the final
result tables}
}
\value{
a list with five elements. Element one is a data frame with
calculated measures for five regression methods. For each regression method
and each calculated measure, mean and standard deviation are given.
Element two is similar to element one: a data frame with ranks of calculated
measures: average rank and share of rank 1 are given. Element three and four
are ggplot objects of mean bias for calibration (element 3) and validation
(element 4) data. If returns argument is set to return only "Calibration" or
"Validation" results, only the three relevant elements will be returned in the
list. Element five is a data frame with specifications of parameters used for
different regression methods.
}
\description{
Calculates performance measures for train and test data of different
regression methods: multiple linear regression (MLR), artificial neural
networks with Bayesian regularization training algorithm (ANN), M5P model
trees (MT), model trees with bagging (BMT) and random forest of regression
trees (RF). Calculated performance measures are correlation coefficient,
root mean squared error (RMSE), root relative squared error (RSSE), index
of agreement (d), reduction of error (RE), coefficient of efficiency
(CE) and mean bias.
}
\examples{
\dontrun{
data(example_dataset_1)

# An example with default settings of machine learning algorithms
experiment_1 <- compare_methods(formula = MVA~.,
dataset = example_dataset_1, k = 10, repeats = 2,
returns = c("Calibration", "Validation"))
experiment_1[[1]] # See a data frame results of mean and standard deviation
# for different methods
experiment_1[[2]] # See a data frame results of average rank and share of
# rank 1 for different methods
experiment_1[[3]] # See a ggplot of mean bias for calibration data
experiment_1[[4]] # See a ggplot of mean bias for validation data
experiment_1[[5]] # Data frame with parameters used for regression methods

experiment_2 <- compare_methods(formula = MVA ~ .,
dataset = example_dataset_1, k = 5, repeats = 100, ANN_neurons = 1,
MT_M = 4, MT_N = FALSE, MT_U = FALSE, MT_R = FALSE, BMT_P = 100,
BMT_I = 100, BMT_M = 4, BMT_N = FALSE, BMT_U = FALSE, BMT_R = FALSE,
RF_mtry = 0, RF_maxnodes = 4, RF_ntree = 200, multiply = 5,
returns = c("Calibration"))
experiment_2[[1]]
experiment_2[[2]]
experiment_2[[3]]

experiment_3 <- compare_methods(formula = MVA~.,
dataset = example_dataset_1, k = 5, repeats = 10,
use_caret = TRUE, returns = c("Validation"))
experiment_3[[1]]
experiment_3[[2]]
experiment_3[[3]]
}
}
\references{
Bishop, C.M., 1995. Neural Networks for Pattern Recognition. Oxford
University Press, Inc. 482 pp.

Breiman, L., 1996. Bagging predictors. Machine Learning 24, 123-140.

Breiman, L., 2001. Random forests. Machine Learning 45, 5-32.

Burden, F., Winkler, D., 2008. Bayesian Regularization of Neural Networks,
in: Livingstone, D.J. (ed.), Artificial Neural Networks: Methods and
Applications, vol. 458. Humana Press, Totowa, NJ, pp. 23-42.

Hastie, T., Tibshirani, R., Friedman, J.H., 2009. The Elements of
Statistical Learning : Data Mining, Inference, and Prediction, 2nd ed.
Springer, New York xxii, 745 p. pp.

Ho, T.K., 1995. Random decision forests, Proceedings of the Third
International Conference on Document Analysis and Recognition Volume 1.
IEEE Computer Society, pp. 278-282.

Hornik, K., Buchta, C., Zeileis, A., 2009. Open-source machine learning: R
meets Weka. Comput. Stat. 24, 225-232.

Perez-Rodriguez, P., Gianola, D., 2016. Brnn: Brnn (Bayesian Regularization
for Feed-forward Neural Networks). R package version 0.6.

Quinlan, J.R., 1992. Learning with Continuous Classes, Proceedings of the
5th Australian Joint Conference on Artificial Intelligence (AI '92). World
Scientific, Hobart, pp. 343-348.
}
