% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/DEMIDiff-methods.R, R/DEMIExperiment-methods.R, R/DEMIResult-methods.R
\docType{methods}
\name{getResult}
\alias{getResult}
\alias{getResult,DEMIDiff-method}
\alias{getResult,DEMIExperiment-method}
\alias{getResult,DEMIResult-method}
\title{Returns the \code{result} parameter}
\usage{
getResult(object)

\S4method{getResult}{DEMIDiff}(object)

\S4method{getResult}{DEMIExperiment}(object)

\S4method{getResult}{DEMIResult}(object)
}
\arguments{
\item{object}{A \code{DEMIExperiment}, \code{DEMIDiff} or \code{DEMIResult} object.}
}
\value{
Returns the \code{result} parameter. For objects of class \code{DEMIExperiment} it returns
		   a \code{list} of \code{DEMIResult} objects. For objects of class \code{DEMIDiff} it returns
		   a single \code{DEMIResult} object and for objects of class \code{DEMIResult} it returns
		   a \code{list}.
}
\description{
Returns the \code{result} parameter stored in the specified object. If the object is of class
\code{DEMIExperiment} then it returns a \code{list} of \code{DEMIResult} objects. If the
object is of class \code{DEMIDiff} then it returns only one \code{DEMIResult} object. But if
the object is of class \code{DEMIResult} then the function returns a \code{list} that
contains the results for every cluster in a \code{data.frame}. However instead of using this
function it maybe easier to use the function \code{getResultTable} that returns the \code{result}
parameter as a \code{data.frame}.
}
\examples{
\dontrun{

# To use the example we need to download a subset of CEL files from
# http://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE9819 published
# by Pradervand et al. 2008.

# Set the destination folder where the downloaded files fill be located.
# It can be any folder of your choosing.
destfolder <- "demitest/testdata/"

# Download packed CEL files and change the names according to the feature
# they represent (for example to include UHR or BRAIN in them to denote the
# features).
# It is good practice to name the files according to their features which
# allows easier identification of the files later.

ftpaddress <- "ftp://ftp.ncbi.nlm.nih.gov/geo/samples/GSM247nnn"
download.file( paste( ftpaddress, "GSM247694/suppl/GSM247694.CEL.gz", sep = "/" ),
		destfile = paste( destfolder, "UHR01_GSM247694.CEL.gz", sep = "" ) )
download.file( paste( ftpaddress, "GSM247695/suppl/GSM247695.CEL.gz", sep = "/" ),
		destfile = paste( destfolder, "UHR02_GSM247695.CEL.gz", sep = "" ) )
download.file( paste( ftpaddress, "GSM247698/suppl/GSM247698.CEL.gz", sep = "/" ),
		destfile = paste( destfolder, "UHR03_GSM247698.CEL.gz", sep = "" ) )
download.file( paste( ftpaddress, "GSM247699/suppl/GSM247699.CEL.gz", sep = "/" ),
		destfile = paste( destfolder, "UHR04_GSM247699.CEL.gz", sep = "" ) )
download.file( paste( ftpaddress, "GSM247696/suppl/GSM247696.CEL.gz", sep = "/" ),
		destfile = paste( destfolder, "BRAIN01_GSM247696.CEL.gz", sep = "" ) )
download.file( paste( ftpaddress, "GSM247697/suppl/GSM247697.CEL.gz", sep = "/" ),
		destfile = paste( destfolder, "BRAIN02_GSM247697.CEL.gz", sep = "" ) )
download.file( paste( ftpaddress, "GSM247700/suppl/GSM247700.CEL.gz", sep = "/" ),
		destfile = paste( destfolder, "BRAIN03_GSM247700.CEL.gz", sep = "" ) )
download.file( paste( ftpaddress, "GSM247701/suppl/GSM247701.CEL.gz", sep = "/" ),
		destfile = paste( destfolder, "BRAIN04_GSM247701.CEL.gz", sep = "" ) )

# We need the gunzip function (located in the R.utils package) to unpack the gz files.
# Also we will remove the original unpacked files for we won't need them.
library( R.utils )
for( i in list.files( destfolder ) ) {
	gunzip( paste( destfolder, i, sep = "" ), remove = TRUE )
}

# Now we can continue the example of the function getResult

# Set up an experiment
demiexp <- DEMIExperiment( analysis = 'gene', celpath = destfolder,
			experiment = 'myexperiment', organism = 'homo_sapiens' )

# Create clusters with an optimized wilcoxon's rank sum test incorporated within demi that
# precalculates the probabilities
demiclust <- DEMIClust( demiexp, group = c( "BRAIN", "UHR" ), clust.method = demi.wilcox.test.fast )

# Calcuate differential expression
demidiff <- DEMIDiff( demiclust )

# Attach results from 'DEMIDiff' object to 'DEMIExperiment' object
demiexp_attached <- attachResult( demiexp, demidiff )

# Retrieve the 'result' parameter
getResult( demiexp_attached )
getResult( demidiff )

}
}
\author{
Sten Ilmjarv
}
\seealso{
\code{DEMIExperiment}, \code{DEMIDiff}, \code{DEMIResult}, \code{getResultTable}
}

