% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install_tensorflow}
\alias{install_tensorflow}
\title{Install the TensorFlow backend}
\usage{
install_tensorflow(
  method = c("conda", "virtualenv"),
  conda = "auto",
  version = "2.0.0",
  extra_packages = NULL,
  ...
)
}
\arguments{
\item{method}{Installation method ("conda" or "virtualenv").}

\item{conda}{Path to conda executable (or "auto" to find conda using the
PATH and other conventional install locations).}

\item{version}{TensorFlow version to install ( by default, "2.0.0").}

\item{extra_packages}{Additional PyPI packages to install along with TensorFlow.}

\item{...}{Other arguments passed to \code{\link[reticulate:py_install]{reticulate::py_install()}}.}
}
\description{
TensorFlow will be installed into an "r-tensorflow" virtual or conda
environment. Note that "virtualenv" is not available on Windows (as this isn't
supported by TensorFlow).
}
\section{Custom Installation}{


Custom installations of TensorFlow are not supported yet by deepredeff.
}

\section{Additional Packages}{


If you wish to add additional PyPI packages to your TensorFlow environment you
can either specify the packages in the \code{extra_packages} argument of \code{install_tensorflow()},
or alternatively install them into an existing environment using the
\code{\link[reticulate:py_install]{reticulate::py_install()}} function.

Notice that this may have undesired side-effects on Windows installations.
}

\examples{
\dontrun{
# Default installation
library(deepredeff)
install_tensorflow()
}

}
