% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train_dnn.R
\name{train_dnn}
\alias{train_dnn}
\title{Train a deep neural network}
\usage{
train_dnn(darch, input, target, input_valid = NULL, target_valid = NULL,
  ..., learn_rate_weight = exp(-10), learn_rate_bias = exp(-10),
  learn_rate_gamma = 1, batch_size = 10, batch_normalization = TRUE,
  dropout_input = 0, dropout_hidden = 0, momentum_initial = 0.6,
  momentum_final = 0.9, momentum_switch = 100, num_epochs = 0,
  error_function = meanSquareErr, report_classification_error = FALSE)
}
\arguments{
\item{darch}{a darch instance}

\item{input}{input data for training}

\item{target}{target data for training}

\item{input_valid}{input data for validation}

\item{target_valid}{target data for validation}

\item{...}{additional input}

\item{learn_rate_weight}{learning rate for the weight matrices}

\item{learn_rate_bias}{learning rate for the biases}

\item{learn_rate_gamma}{learning rate for the gamma}

\item{batch_size}{batch size during training}

\item{batch_normalization}{logical value that determines whether to turn on
batch normalization during training. Recommneded value: T}

\item{dropout_input}{dropout ratio at input layer. Recommneded value: 0.2}

\item{dropout_hidden}{dropout ratio at hidden layers. Recommended value: 0.5}

\item{momentum_initial}{momentum ratio during training. Recommended value: 0.6}

\item{momentum_final}{final momentum during training. Recommended value: 0.9}

\item{momentum_switch}{afther which epoch the final momentum ratio is used during training}

\item{num_epochs}{number of iterations of the training}

\item{error_function}{error function to minimize during training}

\item{report_classification_error}{logical value. T to report the classification error
during training}
}
\value{
a trained deep neural network (darch instance)
}
\description{
This function trains a deep neural network
}
\examples{
# Example of Regression

input <- matrix(runif(1000), 500, 2)
input_valid <- matrix(runif(100), 50, 2)
target <- rowSums(input + input^2)
target_valid <- rowSums(input_valid + input_valid^2)
# create a new deep neural network for classificaiton
dnn_regression <- new_dnn(
 c(2, 50, 50, 20, 1),  # The layer structure of the deep neural network.
 # The first element is the number of input variables.
 # The last element is the number of output variables.
 hidden_layer_default = rectified_linear_unit_function,
 # for hidden layers, use rectified_linear_unit_function
 output_layer_default = linearUnitDerivative
 # for regression, use linearUnitDerivative function
)

 dnn_regression <- train_dnn(
 dnn_regression,

 # training data
 input, # input variable for training
 target, # target variable for training
 input_valid, # input variable for validation
 target_valid, # target variable for validation

 # training parameters
 learn_rate_weight = exp(-8) * 10,
 # learning rate for weights, higher if use dropout
 learn_rate_bias = exp(-8) * 10,
 # learning rate for biases, hihger if use dropout
 learn_rate_gamma = exp(-8) * 10,
 # learning rate for the gamma factor used
 batch_size = 10,
 # number of observations in a batch during training.
 # Higher for faster training. Lower for faster convergence
 batch_normalization = TRUE,
 # logical value, T to use batch normalization
 dropout_input = 0.2,
  # dropout ratio in input.
 dropout_hidden = 0.5,
 # dropout ratio in hidden layers
 momentum_initial = 0.6,
 # initial momentum in Stochastic Gradient Descent training
 momentum_final = 0.9,
 # final momentum in Stochastic Gradient Descent training
 momentum_switch = 100,
 # after which the momentum is switched from initial to final momentum
 num_epochs = 5,
  # number of iterations in training
  # increase numbef of epochs to 100 for better model fit


 # Error function
 error_function = meanSquareErr,
 # error function to minimize during training. For regression, use meanSquareErr
 report_classification_error = FALSE
 # whether to print classification error during training
)


# the prediciton by dnn_regression
pred <- predict(dnn_regression)

# calculate the r-squared of the prediciton
rsq(dnn_regression)


# calcualte the r-squared of the prediciton in validation
rsq(dnn_regression, input = input_valid, target = target_valid)

# print the layer weights
# this function can print heatmap, histogram, or a surface
print_weight(dnn_regression, 1, type = "heatmap")

print_weight(dnn_regression, 2, type = "surface")

print_weight(dnn_regression, 3, type = "histogram")


# Examples of classification

input <- matrix(runif(1000), 500, 2)
input_valid <- matrix(runif(100), 50, 2)
target <- (cos(rowSums(input + input^2)) > 0.5) * 1
target_valid <- (cos(rowSums(input_valid + input_valid^2)) > 0.5) * 1

# create a new deep neural network for classificaiton
dnn_classification <- new_dnn(
 c(2, 50, 50, 20, 1),  # The layer structure of the deep neural network.
 # The first element is the number of input variables.
 # The last element is the number of output variables.
 hidden_layer_default = rectified_linear_unit_function,
 # for hidden layers, use rectified_linear_unit_function
 output_layer_default = sigmoidUnitDerivative
 # for classification, use sigmoidUnitDerivative function
)

dnn_classification <- train_dnn(
 dnn_classification,

 # training data
 input, # input variable for training
 target, # target variable for training
 input_valid, # input variable for validation
 target_valid, # target variable for validation

 # training parameters
 learn_rate_weight = exp(-8) * 10,
 # learning rate for weights, higher if use dropout
 learn_rate_bias = exp(-8) * 10,
 # learning rate for biases, hihger if use dropout
 learn_rate_gamma = exp(-8) * 10,
 # learning rate for the gamma factor used
 batch_size = 10,
 # number of observations in a batch during training.
 # Higher for faster training. Lower for faster convergence
 batch_normalization = TRUE,
 # logical value, T to use batch normalization
 dropout_input = 0.2,
 # dropout ratio in input.
 dropout_hidden = 0.5,
 # dropout ratio in hidden layers
 momentum_initial = 0.6,
 # initial momentum in Stochastic Gradient Descent training
 momentum_final = 0.9,
 # final momentum in Stochastic Gradient Descent training
 momentum_switch = 100,
 # after which the momentum is switched from initial to final momentum
 num_epochs = 5,
 # number of iterations in training
 # increase num_epochs to 100 for better model fit

 # Error function
 error_function = crossEntropyErr,
 # error function to minimize during training. For regression, use crossEntropyErr
 report_classification_error = TRUE
 # whether to print classification error during training
)

# the prediciton by dnn_regression
pred <- predict(dnn_classification)

hist(pred)

# calculate the r-squared of the prediciton
AR(dnn_classification)

# calcualte the r-squared of the prediciton in validation
AR(dnn_classification, input = input_valid, target = target_valid)


}

