% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_downloads.R
\name{plot_downloads}
\alias{plot_downloads}
\alias{plot_downloads.default}
\alias{plot_downloads.deepdep}
\alias{plot_downloads.package_dependencies}
\alias{plot_downloads.package_downloads}
\alias{plot_downloads.character}
\title{Plot download count of CRAN packages.}
\usage{
plot_downloads(x, ...)

\method{plot_downloads}{default}(x, ...)

\method{plot_downloads}{deepdep}(x, from = Sys.Date() - 365, to = Sys.Date(), ...)

\method{plot_downloads}{package_dependencies}(x, from = Sys.Date() - 365, to = Sys.Date(), ...)

\method{plot_downloads}{package_downloads}(x, from = Sys.Date() - 365, to = Sys.Date(), ...)

\method{plot_downloads}{character}(x, from = Sys.Date() - 365, to = Sys.Date(), ...)
}
\arguments{
\item{x}{A \code{character} vector. Names of the packages that are on CRAN.}

\item{...}{Ignored.}

\item{from}{A \code{Date} class object. From which date plot the data. By default it's one year back.}

\item{to}{A \code{Date} class object. To which date plot the data. By default it's now.}
}
\value{
A \code{ggplot2} class object.
}
\description{
This function uses \href{https://github.com/r-hub/cranlogs}{\bold{API}} of
\href{http://cran-logs.rstudio.com/}{\bold{CRAN Logs}} to scrap the download logs of the packages and
then plots the data. It works on objects of class \code{character} (vector),
\code{deepdep}, \code{package_dependencies} and \code{package_downloads}.
}
\examples{
library(deepdep)

plot_downloads("htmltools")

\donttest{
dd <- deepdep("ggplot2")
plot_downloads(dd)
}

}
