% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/paramtnormci_fit.R
\name{paramtnormci_fit}
\alias{paramtnormci_fit}
\title{Fit parameters of truncated normal distribution based on a confidence interval.}
\usage{
paramtnormci_fit(p, ci, median = mean(ci), lowerTrunc = -Inf,
  upperTrunc = Inf, relativeTolerance = 0.05, fitMethod = "Nelder-Mead",
  ...)
}
\arguments{
\item{p}{\code{numeric} 2-dimensional vector; probabilities of upper and lower bound of the
corresponding confidence interval.}

\item{ci}{\code{numeric} 2-dimensional vector; lower, i.e \code{ci[[1]]}, and upper bound, i.e
\code{ci[[2]]}, of the  confidence interval.}

\item{median}{if \code{NULL}: truncated normal is fitted only to lower and upper value of the
confidence interval; if \code{numeric}: truncated normal is fitted on the confidence interval
and the median simultaneously. For details cf. below.}

\item{lowerTrunc}{\code{numeric}; lower truncation point of the distribution (>= \code{-Inf}).}

\item{upperTrunc}{\code{numeric}; upper truncation point of the distribution (<= \code{Inf}).}

\item{relativeTolerance}{\code{numeric}; the relative tolerance level of deviation of the
generated probability levels from the specified confidence interval. If the relative deviation
is greater than \code{relativeTolerance} a warning is given.}

\item{fitMethod}{optimization method used in \code{\link[stats]{constrOptim}}.}

\item{...}{further parameters to be passed to \code{\link[stats]{constrOptim}}.}
}
\value{
A list with elements \code{mean} and \code{sd}, i.e. the parameters of the underlying
  normal distribution.
}
\description{
This function fits the distribution parameters, i.e. \code{mean} and \code{sd}, of a truncated
normal distribution from an arbitrary confidence interval and, optionally, the median.
}
\details{
For details of the truncated normal distribution see \code{\link[msm]{tnorm}}.

  The cumulative distribution of a truncated normal \eqn{F_{\mu, \sigma}}(x) gives the
  probability that a sampled value is less than \eqn{x}. This is equivalent to saying that for
  the vector of quantiles \ifelse{latex}{\eqn{q=(q_{p_1}, \ldots, q_{p_k})}}{\eqn{q=(q(p_1),
  \ldots, q(p_k))}} at the corresponding probabilities \eqn{p=(p_1, \ldots, p_k)} it holds that
    \deqn{p_i = F_{\mu, \sigma}(q_{p_i}),~i = 1, \ldots, k}{p_i = F_{\mu, \sigma}(q(p_i)), i = 1, \ldots k.}
  In the case of arbitrary postulated quantiles this system of equations might not have a
  solution in \eqn{\mu} and \eqn{\sigma}. A least squares fit leads to an approximate solution:
    \deqn{\sum_{i=1}^k (p_i - F_{\mu, \sigma}(q_{p_i}))^2 = \min}{ \sum_{i=1}^k (p_i - F_{\mu, \sigma}(q(p_i)))^2 = min}
  defines the parameters \eqn{\mu} and \eqn{\sigma} of the underlying normal distribution. This
  method solves this minimization problem for two cases:
   \enumerate{
     \item \code{ci[[1]] < median < ci[[2]]}: The parameters are fitted on the lower and upper value
       of the confidence interval and the median, formally:\cr
       \eqn{k=3}\cr
       \eqn{p_1}=\code{p[[1]]}, \eqn{p_2}=\code{0.5} and \eqn{p_3}=\code{p[[2]]};\cr
       \ifelse{latex}{\eqn{q_{p_1}}}{\eqn{q(p_1)}}=\code{ci[[1]]},
       \ifelse{latex}{\eqn{q_{0.5}}}{\eqn{q(0.5)}}=\code{median} and
       \ifelse{latex}{\eqn{q_{p_3}}}{\eqn{q(p_3)}}=\code{ci[[2]]}
     \item \code{median=NULL}: The parameters are fitted on the lower and upper value of the
       confidence interval only, formally:\cr
       \eqn{k=2}\cr
       \eqn{p_1}=\code{p[[1]]}, \eqn{p_2}=\code{p[[2]]};\cr
       \ifelse{latex}{\eqn{q_{p_1}}}{\eqn{q(p_1)}}=\code{ci[[1]]},
       \ifelse{latex}{\eqn{q_{p_2}}}{\eqn{q(p_2)}}=\code{ci[[2]]}
   }
   The \code{(p[[2]]-p[[1]])} - confidence interval must be symmetric in the sense that
   \code{p[[1]] + p[[2]] = 1}.
}
\seealso{
\code{\link[msm]{tnorm}}, \code{\link[stats]{constrOptim}}
}

