% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aa_check.r
\name{aa_check}
\alias{aa_check}
\alias{aa_check.DNAseq}
\title{Translate the sequence and it for stop codons}
\usage{
aa_check(x, ...)

\method{aa_check}{DNAseq}(x, ..., trans_table = 0, frame_offset = 0)
}
\arguments{
\item{x}{a ccs_reads class object.}

\item{...}{additional arguments to be passed between methods.}

\item{trans_table}{The translation table to use for translating from nucleotides to amino acids. Default is "auto", meaning
that the translation table will be inferred from the ccs_reads object's order.}

\item{frame_offset}{The offset to the reading frame to be applied for translation. By default the offset
is zero, so the first character in the framed sequence is considered the first nucelotide of the first codon.
Passing frame_offset = 1 would offset the sequence by one and therefore make the second character in the
framed sequence the the first nucelotide of the first codon.}
}
\value{
a class object of code{"ccs_reads"}
}
\description{
A side product of the framing and adjustment functions is that the reading frame of the sequence is established
and translation can be conducted with high confidence. If the adjustment did in fact correct indel errors, the
translated sequence should feature no stop codons. If stop codons are present this is grounds for rejection as 
indel errors (or some other large issue) persists in the sequence.
}
\details{
This test has limitations, as any indels late in the DNA sequence may not lead to stop codons existing. Additionally
by default censored translation is used by this function when producing the amino acid sequence, so as to 
eliminate taxonomic bias against organisms with esoteric translation tables. The likelihood of catching errors is
increased if the genetic code corresponding to sequences is known.
}
\examples{
#previously called
ex_data = DNAseq(example_nt_string, name = 'ex1')
ex_data =  frame(ex_data)
ex_data = adjust(ex_data)
#run the aa check on the adjusted sequences
ex_data = aa_check(ex_data)
ex_data$aaSeq #view the amino acid sequence
ex_data$stop_codons # Boolean indicating if stop codons in the amino acid sequence

}
\seealso{
\code{\link{DNAseq}}

\code{\link{frame}}

\code{\link{adjust}}
}
