% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_fdh.R
\name{model_fdh}
\alias{model_fdh}
\title{Free disposal hull (FDH) model.}
\usage{
model_fdh(datadea,
          fdh_modelname = c("basic"),
          ...)
}
\arguments{
\item{datadea}{The data, including DMUs, inputs and outputs.}

\item{fdh_modelname}{A string containing the name of the model to apply FDH.
For now, only "basic" is available.}

\item{...}{\code{dmu_eval}, \code{dmu_ref}, \code{orientation} and other model parameters.
Parameters like \code{rts}, \code{max_slack} and \code{returnlp} are ignored.}
}
\description{
FDH model allows the free disposability to construct the production
possibility set. The central feature of the FDH model is the lack of convexity
for its production possibility set (Thrall, 1999).
}
\examples{
# Example 1. FDH input-oriented.
# Replication of results in Sanei and Mamizadeh Chatghayeb (2013)
data("Supply_Chain")
data_fdh1 <- read_data(Supply_Chain, 
                       inputs = 2:4, 
                       outputs = 5:6)
result <- model_fdh(data_fdh1) # by default orientation = "io"
efficiencies(result)

# Example 2. FDH output-oriented.
# Replication of results in Sanei and Mamizadeh Chatghayeb (2013)
data("Supply_Chain")
data_fdh2 <- read_data(Supply_Chain, 
                       inputs = 5:6, 
                       outputs = 7:8)
result2 <- model_fdh(data_fdh2, 
                    orientation = "oo")
efficiencies(result2)
 
}
\references{
Cherchye, L.; Kuosmanen, T.; Post, T. (2000). "What Is the Economic Meaning of
FDH? A Reply to Thrall". Journal of Productivity Analysis, 13(3), 263–267. 

Deprins, D.; Simar, L. and Tulkens, H. (1984). Measuring Labor-Efficiency in
Post Offices. In M. Marchand, P. Pestieau and H. Tulkens (eds.), The Performance
of Public Entreprises: Concepts and Measurement. Amsterdam: North-Holland.

Sanei, M.; Mamizadeh Chatghayeb, S. (2013). “Free Disposal Hull Models in
Supply Chain Management”, International Journal of Mathematical Modelling and
Computations, 3(3), 125-129.

Thrall, R. M. (1999).  "What Is the Economic Meaning of FDH?", Journal of
Productivity Analysis, 11(3), 243–50.
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
