% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_sets.R
\docType{data}
\name{Libraries}
\alias{Libraries}
\title{Data: Cooper, Seiford and Tone (2007).}
\format{
Data frame with 23 rows and 7 columns. Definition of inputs (X) and outputs (Y):
\describe{
  \item{x1 = AREA}{Floor area (unit=1000 m2)}
  \item{x2 = BOOKS}{Number of books (unit=1000)}
  \item{x3 = STAFF}{Staff}
  \item{x4 = POPULATION}{Population (unit=1000)}
  \item{y1 = REGISTERED}{Registered residents (unit=1000)}
  \item{y2 = BORROWED}{Borrowed books (unit=1000)}
}
}
\source{
Cooper, W.W.; Seiford, L.M. and Tone, K. (2007). Data Envelopment Analysis.
A Comprehensive Text with Models, Applications, References and DEA-Solver Software.
Springer.
}
\usage{
data("Libraries")
}
\description{
Data for 23 public libraries of the Tokyo Metropolitan Area in 1986.
}
\examples{
# Example 1. Non-controllable input (POPULATION).
# Replication of results in Cooper, Seiford and Tone (2007, p.221)
data(Libraries)
# POPULATION (non-controllable input) is the 4th input.
data_example <- read_data(Libraries,
                          dmus = 1,
                          inputs = 2:5,
                          nc_inputs = 4,
                          outputs = 6:7)
result <- model_basic(data_example,
                      orientation = "io",
                      rts = "crs")
efficiencies(result)
targets(result)

# Example 2. Non-discretionary input (POPULATION).
data(Libraries)
# POPULATION (non-controllable input) is the 4th input.
data_example2 <- read_data(Libraries,
                           dmus=1,
                           inputs=2:5,
                           nd_inputs=4,
                           outputs=6:7)
result2 <- model_basic(data_example2,
                       orientation="io",
                       rts="crs")
efficiencies(result2)
targets(result2)

}
\seealso{
\code{\link{read_data}}, \code{\link{model_basic}}
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolos} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benitez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
\keyword{datasets}
